/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.collection.CheckedArrayList;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.CheckedHashSet;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.DerivedList;
import org.apache.sis.util.collection.DerivedMap;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.collection.EmptyQueue;
import org.apache.sis.util.collection.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

public final class Containers {
    private Containers() {
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.INSTANCE;
    }

    private static boolean isUnmodifiable(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        if (collection instanceof CheckedContainer) {
            return ((CheckedContainer)((Object)collection)).getMutability().isUnmodifiable();
        }
        return false;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <E> Collection<E> nonNull(Collection<E> collection) {
        return collection != null ? collection : Collections.emptySet();
    }

    public static <E> Set<E> nonNull(Set<E> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static <T> T peekFirst(Iterable<T> collection) {
        Iterator<T> it;
        if (collection != null && (it = collection.iterator()) != null && it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static <T> T peekIfSingleton(Iterable<T> collection) {
        Iterator<T> it;
        if (collection != null && (it = collection.iterator()) != null) {
            T element = null;
            while (it.hasNext()) {
                T next = it.next();
                if (next == null) continue;
                if (element != null) {
                    return null;
                }
                element = next;
            }
            return element;
        }
        return null;
    }

    public static <E> Set<E> singletonOrEmpty(E element) {
        return element != null ? Collections.singleton(element) : Collections.emptySet();
    }

    @SafeVarargs
    public static <E> Set<E> copyToImmutableSetIgnoreNull(E ... elements) {
        return Containers.copyToSet(elements, true);
    }

    @SafeVarargs
    public static <E> Set<E> copyToImmutableSet(E ... elements) {
        return Containers.copyToSet(elements, false);
    }

    private static <E> Set<E> copyToSet(E[] elements, boolean excludeNull) {
        if (elements == null) {
            return null;
        }
        switch (elements.length) {
            case 1: {
                E element = elements[0];
                if (element != null || !excludeNull) {
                    return Collections.singleton(element);
                }
            }
            case 0: {
                return Collections.emptySet();
            }
        }
        LinkedHashSet<E> set = new LinkedHashSet<E>(Arrays.asList(elements));
        if (excludeNull) {
            set.remove(null);
        }
        return Containers.unmodifiable(set);
    }

    public static <E> List<E> copyToImmutableList(Collection<? extends E> collection, Class<E> elementType) {
        if (collection == null) {
            return null;
        }
        return Containers.viewAsUnmodifiableList(collection.toArray(size -> (Object[])Array.newInstance(elementType, size)));
    }

    @SafeVarargs
    public static <E> List<E> viewAsUnmodifiableList(E ... array) {
        return array == null ? null : new UnmodifiableArrayList<E>(array);
    }

    public static <E> List<E> viewAsUnmodifiableList(E[] array, int lower, int upper) {
        Objects.checkFromToIndex(lower, upper, array.length);
        if (lower == 0 && upper == array.length) {
            return new UnmodifiableArrayList<E>(array);
        }
        return new UnmodifiableArrayList.SubList<E>(array, lower, upper - lower);
    }

    @SafeVarargs
    @Deprecated(since="1.6", forRemoval=true)
    public static <E> List<? extends E> unmodifiableList(E ... array) {
        return Containers.viewAsUnmodifiableList(array);
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static <E> List<? extends E> unmodifiableList(E[] array, int lower, int upper) {
        return Containers.viewAsUnmodifiableList(array, lower, upper);
    }

    public static <E> List<E> unmodifiable(List<E> list) {
        if (list != null) {
            int length = list.size();
            switch (length) {
                case 0: {
                    list = Collections.emptyList();
                    break;
                }
                case 1: {
                    list = Collections.singletonList(list.get(0));
                    break;
                }
                default: {
                    if (list instanceof CheckedContainer) {
                        CheckedContainer c = (CheckedContainer)((Object)list);
                        if (c.getMutability().isUnmodifiable()) break;
                        Object[] array = (Object[])Array.newInstance(c.getElementType(), length);
                        list = new UnmodifiableArrayList<Object>(list.toArray(array));
                        break;
                    }
                    list = Collections.unmodifiableList(list);
                }
            }
        }
        return list;
    }

    public static <E> Set<E> unmodifiable(Set<E> set) {
        if (Containers.isUnmodifiable(set)) {
            return set;
        }
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E> Set<E> newCheckedSet(Collection<? extends E> collection, Class<E> elementType) {
        AbstractSet set;
        if (elementType.isEnum()) {
            set = EnumSet.noneOf(elementType);
        } else if (CodeList.class.isAssignableFrom(elementType) && Modifier.isFinal(elementType.getModifiers())) {
            set = new CodeListSet<E>(elementType);
        } else {
            return collection != null ? new CheckedHashSet<E>(collection, elementType) : new CheckedHashSet<E>(elementType);
        }
        if (collection != null) {
            set.addAll(collection);
        }
        return set;
    }

    public static <E> List<E> newCheckedList(Collection<? extends E> collection, Class<E> elementType) {
        return collection != null ? new CheckedArrayList<E>(collection, elementType) : new CheckedArrayList<E>(elementType);
    }

    public static <S, E> List<E> derivedList(List<S> storage, Function<S, E> converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (storage == null) {
            return null;
        }
        return new DerivedList<S, E>(storage, converter);
    }

    public static <S, E> Set<E> derivedSet(Set<S> storage, ObjectConverter<S, E> converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (storage == null) {
            return null;
        }
        return DerivedSet.create(storage, converter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        ArgumentChecks.ensureNonNull("keyConverter", keyConverter);
        ArgumentChecks.ensureNonNull("valueConverter", valueConverter);
        if (storage == null) {
            return null;
        }
        return DerivedMap.create(storage, keyConverter, valueConverter);
    }

    public static Collection<?> toCollection(final Object object) {
        if (object == null) {
            return Collections.emptySet();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return Arrays.asList((Object[])object);
            }
            return new AbstractList<Object>(){

                @Override
                public int size() {
                    return Array.getLength(object);
                }

                @Override
                public Object get(int index) {
                    return Array.get(object, index);
                }

                @Override
                public Object set(int index, Object value) {
                    Object old = Array.get(value, index);
                    Array.set(value, index, value);
                    return old;
                }
            };
        }
        return Collections.singleton(object);
    }

    public static <T> T property(Map<?, ?> properties, Object key, Class<T> type) throws IllegalArgumentException {
        if (properties == null) {
            return null;
        }
        Object value = properties.get(key);
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)74, key, type, value.getClass()));
        }
        return (T)value;
    }

    public static int hashMapCapacity(int count) {
        return (count * 4 + 2) / 3;
    }

    public static <E extends Comparable<E>> int compare(Iterator<E> it1, Iterator<? extends E> it2) {
        while (it1.hasNext()) {
            Comparable o2;
            if (!it2.hasNext()) {
                return 1;
            }
            Comparable o1 = (Comparable)it1.next();
            if (o1 == (o2 = (Comparable)it2.next())) continue;
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int c = o1.compareTo(o2);
            if (c == 0) continue;
            return c;
        }
        return it2.hasNext() ? -1 : 0;
    }
}

