/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.base.ArrayOfLongs;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.Localized;
import org.apache.sis.util.internal.shared.Strings;

abstract class Group<E> {
    private String name;
    final List<E> members = new ArrayList();
    private final Map<Object, Object> sharedInstances;
    final GridCoverageProcessor processor;

    Group(GridCoverageProcessor processor) {
        this.processor = processor;
        this.sharedInstances = new HashMap<Object, Object>();
    }

    Group(Group<?> parent) {
        this.sharedInstances = parent.sharedInstances;
        this.processor = parent.processor;
    }

    abstract String createName(Locale var1);

    final String getName(Localized parent) {
        if (this.name == null) {
            this.name = this.createName(parent != null ? parent.getLocale() : null);
        }
        return this.name;
    }

    final GroupAggregate prepareAggregate(StoreListeners listeners) {
        return new GroupAggregate(this.getName(listeners), listeners, this.members.size());
    }

    final <E> E unique(E object) {
        Object existing = this.sharedInstances.putIfAbsent(object, object);
        return (E)(existing != null ? existing : object);
    }

    final long[] unique(long[] array) {
        return new ArrayOfLongs(array).unique(this.sharedInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int count;
        List<E> list = this.members;
        synchronized (list) {
            count = this.members.size();
        }
        return Strings.toString(this.getClass(), (Object[])new Object[]{"name", this.getName(null), "count", count});
    }
}

