/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.model.request.Prop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropProperty<T>
extends DefaultDavProperty<T> {
    private Map<String, String> attributes = null;
    private Collection<XmlSerializable> children = new ArrayList<XmlSerializable>();

    public PropProperty(String namespaceURI, String namespaceQualifier, String propertyName) {
        this(namespaceURI, namespaceQualifier, propertyName, null);
    }

    public PropProperty(String namespaceURI, String namespaceQualifier, String propertyName, Collection<XmlSerializable> children) {
        this(propertyName, null, Namespace.getNamespace((String)namespaceQualifier, (String)namespaceURI), null, children);
    }

    public PropProperty(String name, Namespace namespace) {
        super(name, null, namespace);
    }

    public PropProperty(String name, T value, Namespace namespace) {
        super(name, value, namespace);
    }

    public PropProperty(String name, T value, Namespace namespace, Map<String, String> attributes) {
        super(name, value, namespace);
        this.attributes = attributes;
    }

    public PropProperty(String name, T value, Namespace namespace, Map<String, String> attributes, Collection<XmlSerializable> children) {
        super(name, value, namespace);
        this.attributes = attributes;
        this.children = children;
    }

    public PropProperty(String name, T value, Namespace namespace, Map<String, String> attributes, DavPropertyNameSet children) {
        super(name, value, namespace);
        this.attributes = attributes;
        this.addChildren(children);
    }

    public PropProperty(String name, T value, Namespace namespace, Map<String, String> attributes, DavPropertySet children) {
        super(name, value, namespace);
        this.attributes = attributes;
        this.addChildren(children);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    public void addChild(XmlSerializable property) {
        if (this.getValue() != null) {
            throw new IllegalStateException("Adding of children not allowed, when value is non null");
        }
        this.children.add(property);
    }

    public void addChildren(Collection<? extends XmlSerializable> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.children.addAll(collection);
    }

    public void addChildren(DavPropertyNameSet propertyNames) {
        if (propertyNames == null || propertyNames.isEmpty()) {
            return;
        }
        this.children.addAll(propertyNames.getContent());
    }

    public void addChildren(DavPropertySet properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (DavProperty property : properties) {
            this.children.add((XmlSerializable)property);
        }
    }

    public void addChildren(Prop<?> prop) {
        this.children.addAll(prop.getChildren());
    }

    public Collection<? extends XmlSerializable> getChildren() {
        return this.children;
    }

    public void removeChild(XmlSerializable prop) {
        if (this.children != null && prop != null) {
            this.children.remove(prop);
        }
    }

    public void removeChildren(DavPropertyNameSet props) {
        if (this.children != null && props != null) {
            this.children.removeAll(props.getContent());
        }
    }

    public void removeChildren(DavPropertySet props) {
        if (this.children != null && props != null) {
            for (DavProperty prop : props) {
                this.children.remove(prop);
            }
        }
    }

    public void removeChildren(Collection<? extends XmlSerializable> props) {
        this.children.removeAll(props);
    }

    public boolean isChildrenEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    public static Collection<DavProperty> getChildrenfromValue(DavProperty property) {
        ArrayList<DavProperty> coll = new ArrayList<DavProperty>();
        if (property != null) {
            if (property.getValue() instanceof DavProperty) {
                coll.add((DavProperty)property.getValue());
                return coll;
            }
            if (property.getValue() instanceof Node[]) {
                for (Node e : (Node[])property.getValue()) {
                    if (!(e instanceof Element)) continue;
                    coll.add((DavProperty)DefaultDavProperty.createFromXml((Element)((Element)e)));
                }
                return coll;
            }
            if (property.getValue() instanceof Collection) {
                for (Object entry : (Collection)property.getValue()) {
                    if (entry instanceof DavProperty) {
                        coll.add((DavProperty)entry);
                        continue;
                    }
                    if (!(entry instanceof Element)) continue;
                    coll.add((DavProperty)DefaultDavProperty.createFromXml((Element)((Element)entry)));
                }
            }
        }
        return coll;
    }

    protected void fillElement(Element e, Document document) {
        Collection<XmlSerializable> children = this.getChildren();
        if (children != null) {
            for (XmlSerializable node : children) {
                Element childNode = node.toXml(document);
                e.appendChild(childNode);
            }
        }
    }

    public Element toXml(Document document) {
        Object value;
        Element elem = this.getName().toXml(document);
        if (this.attributes != null) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                elem.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        if ((value = this.getValue()) != null) {
            if (value instanceof XmlSerializable) {
                elem.appendChild(((XmlSerializable)value).toXml(document));
            } else if (value instanceof Node) {
                Node n = document.importNode((Node)value, true);
                elem.appendChild(n);
            } else if (value instanceof Node[]) {
                for (int i = 0; i < ((Node[])value).length; ++i) {
                    Node n = document.importNode(((Node[])value)[i], true);
                    elem.appendChild(n);
                }
            } else if (value instanceof Collection) {
                for (Object entry : (Collection)value) {
                    if (entry instanceof XmlSerializable) {
                        elem.appendChild(((XmlSerializable)entry).toXml(document));
                        continue;
                    }
                    if (entry instanceof Node) {
                        Node n = document.importNode((Node)entry, true);
                        elem.appendChild(n);
                        continue;
                    }
                    DomUtil.setText((Element)elem, (String)entry.toString());
                }
            } else {
                DomUtil.setText((Element)elem, (String)value.toString());
            }
        } else {
            this.fillElement(elem, document);
        }
        return elem;
    }

    public PropPropertyIterator Iterator() {
        return new PropPropertyIterator();
    }

    protected class PropPropertyIterator {
        private Iterator<XmlSerializable> iter;

        private PropPropertyIterator() {
            this.iter = PropProperty.this.children.iterator();
        }

        public XmlSerializable nextPropertyName() {
            return this.iter.next();
        }

        public void remove() {
            this.iter.remove();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public XmlSerializable next() {
            return this.iter.next();
        }
    }
}

