/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.kurento.jsonrpc.message.Request;

class JsonRpcRequestDeserializer
implements JsonDeserializer<Request<?>> {
    JsonRpcRequestDeserializer() {
    }

    public Request<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonObject)) {
            throw new JsonParseException("Invalid JsonRpc request showning JsonElement type " + json.getClass().getSimpleName());
        }
        JsonObject jObject = (JsonObject)json;
        if (!jObject.has("method")) {
            throw new JsonParseException("Invalid JsonRpc request lacking 'method' field");
        }
        Integer id = null;
        if (jObject.has("id")) {
            id = jObject.get("id").getAsInt();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeOfT;
        return new Request<Object>(id, jObject.get("method").getAsString(), context.deserialize(jObject.get("params"), parameterizedType.getActualTypeArguments()[0]));
    }
}

