/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccess
extends AccessStrategy {
    private final Class<?> beanClass;
    private final String propertyName;
    private Field rememberField;

    public PropertyAccess(Class<?> clazz, String propertyName) {
        this.beanClass = clazz;
        this.propertyName = propertyName;
    }

    @Override
    public ElementType getElementType() {
        return this.rememberField != null ? ElementType.FIELD : ElementType.METHOD;
    }

    private static Object getPublicProperty(Object bean, String property) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (bean instanceof Map) {
            return ((Map)bean).get(property);
        }
        return PropertyUtils.getSimpleProperty(bean, property);
    }

    public static Object getProperty(Object bean, String propertyName) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return new PropertyAccess(bean.getClass(), propertyName).get(bean);
    }

    public String toString() {
        return "Property{" + this.beanClass.getName() + '.' + this.propertyName + '}';
    }

    @Override
    public Type getJavaType() {
        Type result = this.getTypeInner();
        return result == null ? Object.class : result;
    }

    public boolean isKnown() {
        return this.getTypeInner() != null;
    }

    private Type getTypeInner() {
        if (this.rememberField != null) {
            return this.rememberField.getGenericType();
        }
        Method readMethod = PropertyAccess.getPropertyReadMethod(this.propertyName, this.beanClass);
        if (readMethod != null) {
            return readMethod.getGenericReturnType();
        }
        Field fld = PropertyAccess.getField(this.propertyName, this.beanClass);
        if (fld != null) {
            this.cacheField(fld);
            return this.rememberField.getGenericType();
        }
        return null;
    }

    private static Method getPropertyReadMethod(String propertyName, Class<?> beanClass) {
        for (PropertyDescriptor each : PropertyUtils.getPropertyDescriptors(beanClass)) {
            if (!each.getName().equals(propertyName)) continue;
            return each.getReadMethod();
        }
        return null;
    }

    private static Field getField(String propertyName, Class<?> beanClass) {
        try {
            return beanClass.getField(propertyName);
        }
        catch (NoSuchFieldException ex2) {
            for (Class<?> theClass = beanClass; theClass != null; theClass = theClass.getSuperclass()) {
                try {
                    return theClass.getDeclaredField(propertyName);
                }
                catch (NoSuchFieldException ex3) {
                    continue;
                }
            }
            return null;
        }
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Object get(Object bean) {
        try {
            if (this.rememberField != null) {
                return this.rememberField.get(bean);
            }
            try {
                return PropertyAccess.getPublicProperty(bean, this.propertyName);
            }
            catch (NoSuchMethodException ex) {
                return this.getFieldValue(bean);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot access " + this.propertyName, e);
        }
    }

    private Object getFieldValue(Object bean) throws IllegalAccessException {
        Field field = PropertyAccess.getField(this.propertyName, this.beanClass);
        if (field != null) {
            this.cacheField(field);
            return this.rememberField.get(bean);
        }
        throw new IllegalArgumentException("cannot access field " + this.propertyName);
    }

    private void cacheField(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.rememberField = field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyAccess that = (PropertyAccess)o;
        return this.beanClass.equals(that.beanClass) && this.propertyName.equals(that.propertyName);
    }

    public int hashCode() {
        int result = this.beanClass.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        return result;
    }
}

