/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.slice.DistributedBrokerImpl;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.FinderTargetPolicy;
import org.apache.openjpa.slice.QueryTargetPolicy;
import org.apache.openjpa.slice.ReplicationPolicy;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.jdbc.DistributedDataSource;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.util.UserException;

public class DistributedJDBCConfigurationImpl
extends JDBCConfigurationImpl
implements DistributedJDBCConfiguration {
    private final List<Slice> _slices = new ArrayList<Slice>();
    private Slice _master;
    private DistributedDataSource virtualDataSource;
    protected BooleanValue lenientPlugin;
    protected StringValue masterPlugin;
    protected StringListValue namesPlugin;
    public PluginValue distributionPolicyPlugin;
    public PluginValue replicationPolicyPlugin;
    public PluginValue queryTargetPolicyPlugin;
    public PluginValue finderTargetPolicyPlugin;
    public StringListValue replicatedTypesPlugin;
    private ReplicatedTypeRepository _replicationRepos;
    public static final String DOT = ".";
    public static final String REGEX_DOT = "\\.";
    public static final String PREFIX_SLICE = "openjpa.slice.";
    public static final String PREFIX_OPENJPA = "openjpa.";
    private static Localizer _loc = Localizer.forPackage(DistributedJDBCConfigurationImpl.class);

    public DistributedJDBCConfigurationImpl() {
        super(true, false);
        this.brokerPlugin.setString(DistributedBrokerImpl.class.getName());
        this.distributionPolicyPlugin = this.addPlugin("openjpa.slice.DistributionPolicy", true);
        this.distributionPolicyPlugin.setAlias("random", DistributionPolicy.Default.class.getName());
        this.distributionPolicyPlugin.setDefault("random");
        this.distributionPolicyPlugin.setString("random");
        this.distributionPolicyPlugin.setDynamic(true);
        this.replicationPolicyPlugin = this.addPlugin("openjpa.slice.ReplicationPolicy", true);
        this.replicationPolicyPlugin.setAlias("all", ReplicationPolicy.Default.class.getName());
        this.replicationPolicyPlugin.setDefault("all");
        this.replicationPolicyPlugin.setString("all");
        this.replicationPolicyPlugin.setDynamic(true);
        this.queryTargetPolicyPlugin = this.addPlugin("openjpa.slice.QueryTargetPolicy", true);
        this.queryTargetPolicyPlugin.setDynamic(true);
        this.finderTargetPolicyPlugin = this.addPlugin("openjpa.slice.FinderTargetPolicy", true);
        this.finderTargetPolicyPlugin.setDynamic(true);
        this.replicatedTypesPlugin = new StringListValue("openjpa.slice.ReplicatedTypes");
        this.addValue(this.replicatedTypesPlugin);
        this.lenientPlugin = this.addBoolean("openjpa.slice.Lenient");
        this.lenientPlugin.setDefault("true");
        this.masterPlugin = this.addString("openjpa.slice.Master");
        this.namesPlugin = this.addStringList("openjpa.slice.Names");
    }

    public DistributedJDBCConfigurationImpl(ConfigurationProvider cp) {
        this();
        cp.setInto(this);
        this.setDiagnosticContext(this);
    }

    private void setDiagnosticContext(OpenJPAConfiguration conf) {
        LogFactory logFactory = conf.getLogFactory();
        try {
            Method setter = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(logFactory.getClass(), "setDiagnosticContext", new Class[]{String.class}));
            setter.invoke((Object)logFactory, conf.getId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public List<String> getActiveSliceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Slice slice : this._slices) {
            if (!slice.isActive() || result.contains(slice.getName())) continue;
            result.add(slice.getName());
        }
        return result;
    }

    @Override
    public List<String> getAvailableSliceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Slice slice : this._slices) {
            result.add(slice.getName());
        }
        return result;
    }

    @Override
    public List<Slice> getSlices(Slice.Status ... statuses) {
        if (statuses == null) {
            return this._slices == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._slices);
        }
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (Slice slice : this._slices) {
            for (Slice.Status status : statuses) {
                if (!slice.getStatus().equals((Object)status)) continue;
                result.add(slice);
            }
        }
        return result;
    }

    @Override
    public Slice getSlice(String name) {
        return this.getSlice(name, false);
    }

    public Slice getSlice(String name, boolean mustExist) {
        for (Slice slice : this._slices) {
            if (!slice.getName().equals(name)) continue;
            return slice;
        }
        if (mustExist) {
            throw new UserException(_loc.get("slice-not-found", name, this.getActiveSliceNames()));
        }
        return null;
    }

    @Override
    public DistributionPolicy getDistributionPolicyInstance() {
        if (this.distributionPolicyPlugin.get() == null) {
            this.distributionPolicyPlugin.instantiate(DistributionPolicy.class, this, true);
        }
        return (DistributionPolicy)this.distributionPolicyPlugin.get();
    }

    @Override
    public String getDistributionPolicy() {
        if (this.distributionPolicyPlugin.get() == null) {
            this.distributionPolicyPlugin.instantiate(DistributionPolicy.class, this, true);
        }
        return this.distributionPolicyPlugin.getString();
    }

    @Override
    public void setDistributionPolicyInstance(DistributionPolicy policy) {
        this.distributionPolicyPlugin.set(policy);
    }

    @Override
    public void setDistributionPolicy(String policy) {
        this.distributionPolicyPlugin.setString(policy);
    }

    @Override
    public ReplicationPolicy getReplicationPolicyInstance() {
        if (this.replicationPolicyPlugin.get() == null) {
            this.replicationPolicyPlugin.instantiate(ReplicationPolicy.class, this, true);
        }
        return (ReplicationPolicy)this.replicationPolicyPlugin.get();
    }

    @Override
    public String getReplicationPolicy() {
        if (this.replicationPolicyPlugin.get() == null) {
            this.replicationPolicyPlugin.instantiate(ReplicationPolicy.class, this, true);
        }
        return this.replicationPolicyPlugin.getString();
    }

    @Override
    public void setReplicationPolicyInstance(ReplicationPolicy policy) {
        this.replicationPolicyPlugin.set(policy);
    }

    @Override
    public void setReplicationPolicy(String policy) {
        this.replicationPolicyPlugin.setString(policy);
    }

    @Override
    public QueryTargetPolicy getQueryTargetPolicyInstance() {
        if (this.queryTargetPolicyPlugin.get() == null) {
            this.queryTargetPolicyPlugin.instantiate(QueryTargetPolicy.class, this, true);
        }
        return (QueryTargetPolicy)this.queryTargetPolicyPlugin.get();
    }

    @Override
    public String getQueryTargetPolicy() {
        if (this.queryTargetPolicyPlugin.get() == null) {
            this.queryTargetPolicyPlugin.instantiate(QueryTargetPolicy.class, this, true);
        }
        return this.queryTargetPolicyPlugin.getString();
    }

    @Override
    public void setQueryTargetPolicyInstance(QueryTargetPolicy policy) {
        this.queryTargetPolicyPlugin.set(policy);
    }

    @Override
    public void setQueryTargetPolicy(String policy) {
        this.queryTargetPolicyPlugin.setString(policy);
    }

    @Override
    public FinderTargetPolicy getFinderTargetPolicyInstance() {
        if (this.finderTargetPolicyPlugin.get() == null) {
            this.finderTargetPolicyPlugin.instantiate(FinderTargetPolicy.class, this, true);
        }
        return (FinderTargetPolicy)this.finderTargetPolicyPlugin.get();
    }

    @Override
    public String getFinderTargetPolicy() {
        if (this.finderTargetPolicyPlugin.get() == null) {
            this.finderTargetPolicyPlugin.instantiate(FinderTargetPolicy.class, this, true);
        }
        return this.finderTargetPolicyPlugin.getString();
    }

    @Override
    public void setFinderTargetPolicyInstance(FinderTargetPolicy policy) {
        this.finderTargetPolicyPlugin.set(policy);
    }

    @Override
    public void setFinderTargetPolicy(String policy) {
        this.finderTargetPolicyPlugin.setString(policy);
    }

    @Override
    public DistributedDataSource getConnectionFactory() {
        if (this.virtualDataSource == null) {
            this.virtualDataSource = this.createDistributedDataStore();
            DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), this.virtualDataSource, this, false);
        }
        return this.virtualDataSource;
    }

    public boolean isLenient() {
        return this.lenientPlugin.get();
    }

    public void setLenient(boolean lenient) {
        this.lenientPlugin.set(lenient);
    }

    public void setMaster(String master) {
        this.masterPlugin.set(master);
    }

    @Override
    public Slice getMasterSlice() {
        if (this._master == null) {
            String value = this.masterPlugin.get();
            this._master = value == null ? this._slices.get(0) : this.getSlice(value, true);
        }
        return this._master;
    }

    private DistributedDataSource createDistributedDataStore() {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        boolean isXA = true;
        for (Slice slice : this._slices) {
            try {
                DataSource ds = this.createDataSource(slice);
                dataSources.add(ds);
                isXA &= this.isXACompliant(ds);
            }
            catch (Throwable ex) {
                this.handleBadConnection(this.isLenient(), slice, ex);
            }
        }
        if (dataSources.isEmpty()) {
            throw new UserException(_loc.get("no-slice"));
        }
        DistributedDataSource result = new DistributedDataSource(dataSources);
        return result;
    }

    DataSource createDataSource(Slice slice) throws Exception {
        JDBCConfiguration conf = (JDBCConfiguration)slice.getConfiguration();
        DataSource ds = (DataSource)conf.getConnectionFactory();
        if (ds == null) {
            Log log = conf.getConfigurationLog();
            String url = this.getConnectionInfo(conf);
            if (log.isInfoEnabled()) {
                log.info(_loc.get("slice-connect", slice, url));
            }
            ds = DataSourceFactory.newDataSource(conf, false);
            DecoratingDataSource dds = new DecoratingDataSource(ds);
            ds = DataSourceFactory.installDBDictionary(conf.getDBDictionaryInstance(), dds, conf, false);
        }
        this.verifyDataSource(slice, ds, conf);
        return ds;
    }

    String getConnectionInfo(OpenJPAConfiguration conf) {
        String result = conf.getConnectionURL();
        if (result == null) {
            result = conf.getConnectionDriverName();
            String props = conf.getConnectionProperties();
            if (props != null) {
                result = result + "(" + props + ")";
            }
        }
        return result;
    }

    boolean isXACompliant(DataSource ds) {
        if (ds instanceof DelegatingDataSource) {
            return ((DelegatingDataSource)ds).getInnermostDelegate() instanceof XADataSource;
        }
        return ds instanceof XADataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyDataSource(Slice slice, DataSource ds, JDBCConfiguration conf) {
        Connection con = null;
        try {
            con = ds.getConnection(conf.getConnectionUserName(), conf.getConnectionPassword());
            slice.setStatus(Slice.Status.ACTIVE);
            if (con == null) {
                slice.setStatus(Slice.Status.INACTIVE);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            slice.setStatus(Slice.Status.INACTIVE);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private void handleBadConnection(boolean isLenient, Slice slice, Throwable ex) {
        OpenJPAConfiguration conf = slice.getConfiguration();
        String url = conf.getConnectionURL();
        Log log = conf.getConfigurationLog();
        if (isLenient) {
            if (ex != null) {
                log.warn(_loc.get("slice-connect-known-warn", slice, url, ex.getCause()));
            } else {
                log.warn(_loc.get("slice-connect-warn", slice, url));
            }
        } else {
            if (ex != null) {
                throw new UserException(_loc.get("slice-connect-known-error", slice, url, ex), ex.getCause());
            }
            throw new UserException(_loc.get("slice-connect-error", slice, url));
        }
    }

    private Slice newSlice(String key, Map original) {
        JDBCConfigurationImpl child = new JDBCConfigurationImpl();
        child.fromProperties(this.createSliceProperties(original, key));
        child.setId(this.getId() + DOT + key);
        this.setDiagnosticContext(child);
        child.setMappingDefaults(this.getMappingDefaultsInstance());
        child.setDataCacheManager(this.getDataCacheManagerInstance());
        child.setMetaDataRepository(this.getMetaDataRepositoryInstance());
        Slice slice = new Slice(key, child);
        Log log = this.getConfigurationLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("slice-configuration", key, child.toProperties(false)));
        }
        return slice;
    }

    private List<String> findSlices(Map p) {
        ArrayList<String> sliceNames = new ArrayList();
        Log log = this.getConfigurationLog();
        String key = this.namesPlugin.getProperty();
        boolean explicit = p.containsKey(key);
        if (explicit) {
            String[] values;
            for (String name : values = p.get(key).toString().split("\\,")) {
                if (sliceNames.contains(name.trim())) continue;
                sliceNames.add(name.trim());
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn(_loc.get("no-slice-names", key));
            }
            sliceNames = this.scanForSliceNames(p);
            Collections.sort(sliceNames);
        }
        if (log.isInfoEnabled()) {
            log.info(_loc.get("slice-available", sliceNames));
        }
        return sliceNames;
    }

    private List<String> scanForSliceNames(Map p) {
        ArrayList<String> sliceNames = new ArrayList<String>();
        for (Object o : p.keySet()) {
            String sliceName;
            String key = o.toString();
            if (!key.startsWith(PREFIX_SLICE) || DistributedJDBCConfigurationImpl.getPartCount(key) <= 3 || sliceNames.contains(sliceName = DistributedJDBCConfigurationImpl.chopTail(DistributedJDBCConfigurationImpl.chopHead(o.toString(), PREFIX_SLICE), DOT))) continue;
            sliceNames.add(sliceName);
        }
        return sliceNames;
    }

    private static int getPartCount(String s) {
        return s == null ? 0 : s.split(REGEX_DOT).length;
    }

    private static String chopHead(String s, String head) {
        if (s.startsWith(head)) {
            return s.substring(head.length());
        }
        return s;
    }

    private static String chopTail(String s, String tail) {
        int i = s.lastIndexOf(tail);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    Map createSliceProperties(Map original, String slice) {
        Properties result = new Properties();
        String prefix = PREFIX_SLICE + slice + DOT;
        for (Object o : original.keySet()) {
            String newKey;
            String key = o.toString();
            Object value = original.get(key);
            if (value == null) continue;
            if (key.startsWith(prefix)) {
                newKey = PREFIX_OPENJPA + key.substring(prefix.length());
                result.put(newKey, value);
                continue;
            }
            if (key.startsWith(PREFIX_SLICE)) continue;
            if (key.startsWith(PREFIX_OPENJPA)) {
                newKey = prefix + key.substring(PREFIX_OPENJPA.length());
                if (original.containsKey(newKey)) continue;
                result.put(key, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    Slice addSlice(String name, Map newProps) {
        String prefix = "openjpa.slice.." + name + DOT;
        for (Object key : newProps.keySet()) {
            if (String.class.isInstance(key) || !key.toString().startsWith(prefix)) continue;
            throw new UserException(_loc.get("slice-add-wrong-key", key));
        }
        Slice slice = this.getSlice(name);
        if (slice != null) {
            throw new UserException(_loc.get("slice-exists", name));
        }
        Map original = super.toProperties(true);
        original.putAll(newProps);
        slice = this.newSlice(name, original);
        this._slices.add(slice);
        try {
            this.getConnectionFactory().addDataSource(this.createDataSource(slice));
        }
        catch (Exception ex) {
            this.handleBadConnection(false, slice, ex);
            return null;
        }
        return slice;
    }

    @Override
    public void fromProperties(Map original) {
        super.fromProperties(original);
        this.setDiagnosticContext(this);
        List<String> sliceNames = this.findSlices(original);
        for (String name : sliceNames) {
            Slice slice = this.newSlice(name, original);
            this._slices.add(slice);
        }
    }

    @Override
    public DecoratingDataSource createConnectionFactory() {
        if (this.virtualDataSource == null) {
            this.virtualDataSource = this.createDistributedDataStore();
        }
        return this.virtualDataSource;
    }

    @Override
    public boolean isReplicated(Class<?> cls) {
        if (this._replicationRepos == null) {
            this._replicationRepos = new ReplicatedTypeRepository(this.getMetaDataRepositoryInstance(), Arrays.asList(this.replicatedTypesPlugin.get()));
        }
        return this._replicationRepos.contains(cls);
    }

    private static class ReplicatedTypeRepository {
        private Set<Class<?>> _replicatedTypes = new HashSet();
        private Set<Class<?>> _nonreplicatedTypes = new HashSet();
        List<String> names;
        MetaDataRepository repos;

        ReplicatedTypeRepository(MetaDataRepository repos, List<String> given) {
            this.names = given;
            this.repos = repos;
        }

        boolean contains(Class<?> cls) {
            if (this._replicatedTypes.contains(cls)) {
                return true;
            }
            if (this._nonreplicatedTypes.contains(cls)) {
                return false;
            }
            ClassMetaData meta = this.repos.getMetaData(cls, null, false);
            if (meta == null) {
                this._nonreplicatedTypes.add(cls);
                return false;
            }
            boolean replicated = this.names.contains(meta.getDescribedType().getName());
            if (replicated) {
                this._replicatedTypes.add(cls);
            } else {
                this._nonreplicatedTypes.add(cls);
            }
            return replicated;
        }
    }
}

