/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.util.TlsPlatform;

public class NiFiClientConfig {
    private final String baseUrl;
    private final SSLContext sslContext;
    private final String keystoreFilename;
    private final String keystorePass;
    private final String keyPass;
    private final KeystoreType keystoreType;
    private final String truststoreFilename;
    private final String truststorePass;
    private final KeystoreType truststoreType;
    private final String protocol;
    private final HostnameVerifier hostnameVerifier;
    private final Integer readTimeout;
    private final Integer connectTimeout;

    private NiFiClientConfig(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.sslContext = builder.sslContext;
        this.keystoreFilename = builder.keystoreFilename;
        this.keystorePass = builder.keystorePass;
        this.keyPass = builder.keyPass;
        this.keystoreType = builder.keystoreType;
        this.truststoreFilename = builder.truststoreFilename;
        this.truststorePass = builder.truststorePass;
        this.truststoreType = builder.truststoreType;
        this.protocol = builder.protocol == null ? TlsPlatform.getLatestProtocol() : builder.protocol;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public SSLContext getSslContext() {
        KeyStore trustStore;
        KeyStore keyStore;
        block23: {
            block22: {
                if (this.sslContext != null) {
                    return this.sslContext;
                }
                if (this.keystoreFilename != null && this.keystorePass != null && this.keystoreType != null) {
                    try (InputStream keyStoreStream = Files.newInputStream(Paths.get(this.keystoreFilename, new String[0]), new OpenOption[0]);){
                        keyStore = new StandardKeyStoreBuilder().inputStream(keyStoreStream).password(this.keystorePass.toCharArray()).type(this.keystoreType.name()).build();
                        break block22;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Read Key Store [%s] failed", this.keystoreFilename), e);
                    }
                }
                keyStore = null;
            }
            if (this.truststoreFilename != null && this.truststorePass != null && this.truststoreType != null) {
                try (InputStream keyStoreStream = Files.newInputStream(Paths.get(this.truststoreFilename, new String[0]), new OpenOption[0]);){
                    trustStore = new StandardKeyStoreBuilder().inputStream(keyStoreStream).password(this.truststorePass.toCharArray()).type(this.truststoreType.name()).build();
                    break block23;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Read Trust Store [%s] failed", this.truststoreFilename), e);
                }
            }
            trustStore = null;
        }
        if (keyStore != null || trustStore != null) {
            StandardSslContextBuilder builder = new StandardSslContextBuilder();
            builder.protocol(this.protocol);
            if (keyStore != null) {
                char[] keyPassword = this.keyPass == null ? this.keystorePass.toCharArray() : this.keyPass.toCharArray();
                builder.keyPassword(keyPassword);
                builder.keyStore(keyStore);
            }
            if (trustStore != null) {
                builder.trustStore(trustStore);
            }
            return builder.build();
        }
        return null;
    }

    public String getKeystoreFilename() {
        return this.keystoreFilename;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststoreFilename() {
        return this.truststoreFilename;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public KeystoreType getTruststoreType() {
        return this.truststoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public static class Builder {
        private String baseUrl;
        private SSLContext sslContext;
        private String keystoreFilename;
        private String keystorePass;
        private String keyPass;
        private KeystoreType keystoreType;
        private String truststoreFilename;
        private String truststorePass;
        private KeystoreType truststoreType;
        private String protocol;
        private HostnameVerifier hostnameVerifier;
        private Integer readTimeout;
        private Integer connectTimeout;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder keystoreFilename(String keystoreFilename) {
            this.keystoreFilename = keystoreFilename;
            return this;
        }

        public Builder keystorePassword(String keystorePass) {
            this.keystorePass = keystorePass;
            return this;
        }

        public Builder keyPassword(String keyPass) {
            this.keyPass = keyPass;
            return this;
        }

        public Builder keystoreType(KeystoreType keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder truststoreFilename(String truststoreFilename) {
            this.truststoreFilename = truststoreFilename;
            return this;
        }

        public Builder truststorePassword(String truststorePass) {
            this.truststorePass = truststorePass;
            return this;
        }

        public Builder truststoreType(KeystoreType truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public NiFiClientConfig build() {
            return new NiFiClientConfig(this);
        }
    }
}

