/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.ldap.tenants;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.security.ldap.LdapAuthenticationStrategy;
import org.apache.nifi.registry.security.ldap.LdapsSocketFactory;
import org.apache.nifi.registry.security.ldap.ReferralStrategy;
import org.apache.nifi.registry.security.ldap.tenants.SearchScope;
import org.apache.nifi.registry.security.ldap.tenants.TenantHolder;
import org.apache.nifi.registry.util.FormatUtils;
import org.apache.nifi.registry.util.PropertyValue;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;

public class LdapUserGroupProvider
implements UserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserGroupProvider.class);
    public static final String PROP_CONNECT_TIMEOUT = "Connect Timeout";
    public static final String PROP_READ_TIMEOUT = "Read Timeout";
    public static final String PROP_AUTHENTICATION_STRATEGY = "Authentication Strategy";
    public static final String PROP_MANAGER_DN = "Manager DN";
    public static final String PROP_MANAGER_PASSWORD = "Manager Password";
    public static final String PROP_REFERRAL_STRATEGY = "Referral Strategy";
    public static final String PROP_URL = "Url";
    public static final String PROP_PAGE_SIZE = "Page Size";
    public static final String PROP_GROUP_MEMBERSHIP_ENFORCE_CASE_SENSITIVITY = "Group Membership - Enforce Case Sensitivity";
    public static final String PROP_USER_SEARCH_BASE = "User Search Base";
    public static final String PROP_USER_OBJECT_CLASS = "User Object Class";
    public static final String PROP_USER_SEARCH_SCOPE = "User Search Scope";
    public static final String PROP_USER_SEARCH_FILTER = "User Search Filter";
    public static final String PROP_USER_IDENTITY_ATTRIBUTE = "User Identity Attribute";
    public static final String PROP_USER_GROUP_ATTRIBUTE = "User Group Name Attribute";
    public static final String PROP_USER_GROUP_REFERENCED_GROUP_ATTRIBUTE = "User Group Name Attribute - Referenced Group Attribute";
    public static final String PROP_GROUP_SEARCH_BASE = "Group Search Base";
    public static final String PROP_GROUP_OBJECT_CLASS = "Group Object Class";
    public static final String PROP_GROUP_SEARCH_SCOPE = "Group Search Scope";
    public static final String PROP_GROUP_SEARCH_FILTER = "Group Search Filter";
    public static final String PROP_GROUP_NAME_ATTRIBUTE = "Group Name Attribute";
    public static final String PROP_GROUP_MEMBER_ATTRIBUTE = "Group Member Attribute";
    public static final String PROP_GROUP_MEMBER_REFERENCED_USER_ATTRIBUTE = "Group Member Attribute - Referenced User Attribute";
    public static final String PROP_SYNC_INTERVAL = "Sync Interval";
    private IdentityMapper identityMapper;
    private ScheduledExecutorService ldapSync;
    private final AtomicReference<TenantHolder> tenants = new AtomicReference<Object>(null);
    private String userSearchBase;
    private SearchScope userSearchScope;
    private String userSearchFilter;
    private String userIdentityAttribute;
    private String userObjectClass;
    private String userGroupNameAttribute;
    private String userGroupReferencedGroupAttribute;
    private boolean useDnForUserIdentity;
    private boolean performUserSearch;
    private String groupSearchBase;
    private SearchScope groupSearchScope;
    private String groupSearchFilter;
    private String groupMemberAttribute;
    private String groupMemberReferencedUserAttribute;
    private String groupNameAttribute;
    private String groupObjectClass;
    private boolean useDnForGroupName;
    private boolean performGroupSearch;
    private Integer pageSize;
    private boolean groupMembershipEnforceCaseSensitivity;

    public void initialize(final UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.ldapSync = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            final ThreadFactory factory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.factory.newThread(r);
                thread.setName(String.format("%s (%s) - background sync thread", this.getClass().getSimpleName(), initializationContext.getIdentifier()));
                return thread;
            }
        });
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        long syncInterval;
        ReferralStrategy referralStrategy;
        LdapAuthenticationStrategy authenticationStrategy;
        LdapContextSource context = new LdapContextSource();
        HashMap<String, Object> baseEnvironment = new HashMap<String, Object>();
        this.setTimeout(configurationContext, baseEnvironment, PROP_CONNECT_TIMEOUT, "com.sun.jndi.ldap.connect.timeout");
        this.setTimeout(configurationContext, baseEnvironment, PROP_READ_TIMEOUT, "com.sun.jndi.ldap.read.timeout");
        PropertyValue rawAuthenticationStrategy = configurationContext.getProperty(PROP_AUTHENTICATION_STRATEGY);
        try {
            authenticationStrategy = LdapAuthenticationStrategy.valueOf(rawAuthenticationStrategy.getValue());
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized authentication strategy '%s'. Possible values are [%s]", rawAuthenticationStrategy.getValue(), StringUtils.join((Object[])LdapAuthenticationStrategy.values(), (String)", ")));
        }
        block7 : switch (authenticationStrategy) {
            case ANONYMOUS: {
                context.setAnonymousReadOnly(true);
                break;
            }
            default: {
                String userDn = configurationContext.getProperty(PROP_MANAGER_DN).getValue();
                String password = configurationContext.getProperty(PROP_MANAGER_PASSWORD).getValue();
                context.setUserDn(userDn);
                context.setPassword(password);
                switch (authenticationStrategy) {
                    case SIMPLE: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        break block7;
                    }
                    case LDAPS: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        baseEnvironment.put("java.naming.security.protocol", "ssl");
                        SSLContext ldapsSslContext = this.getConfiguredSslContext(configurationContext);
                        if (ldapsSslContext == null) break block7;
                        LdapsSocketFactory.initialize(ldapsSslContext.getSocketFactory());
                        baseEnvironment.put("java.naming.ldap.factory.socket", LdapsSocketFactory.class.getName());
                        break block7;
                    }
                    case START_TLS: {
                        SSLContext startTlsSslContext;
                        DefaultTlsDirContextAuthenticationStrategy tlsAuthenticationStrategy = new DefaultTlsDirContextAuthenticationStrategy();
                        String rawShutdownGracefully = configurationContext.getProperty("TLS - Shutdown Gracefully").getValue();
                        if (StringUtils.isNotBlank((CharSequence)rawShutdownGracefully)) {
                            boolean shutdownGracefully = Boolean.TRUE.toString().equalsIgnoreCase(rawShutdownGracefully);
                            tlsAuthenticationStrategy.setShutdownTlsGracefully(shutdownGracefully);
                        }
                        if ((startTlsSslContext = this.getConfiguredSslContext(configurationContext)) != null) {
                            tlsAuthenticationStrategy.setSslSocketFactory(startTlsSslContext.getSocketFactory());
                        }
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)tlsAuthenticationStrategy);
                    }
                }
            }
        }
        String rawReferralStrategy = configurationContext.getProperty(PROP_REFERRAL_STRATEGY).getValue();
        try {
            referralStrategy = ReferralStrategy.valueOf(rawReferralStrategy);
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized referral strategy '%s'. Possible values are [%s]", rawReferralStrategy, StringUtils.join((Object[])ReferralStrategy.values(), (String)", ")));
        }
        context.setReferral(referralStrategy.getValue());
        String urls = configurationContext.getProperty(PROP_URL).getValue();
        if (StringUtils.isBlank((CharSequence)urls)) {
            throw new SecurityProviderCreationException("LDAP identity provider 'Url' must be specified.");
        }
        context.setUrls(StringUtils.split((String)urls));
        PropertyValue rawUserSearchBase = configurationContext.getProperty(PROP_USER_SEARCH_BASE);
        PropertyValue rawUserObjectClass = configurationContext.getProperty(PROP_USER_OBJECT_CLASS);
        PropertyValue rawUserSearchScope = configurationContext.getProperty(PROP_USER_SEARCH_SCOPE);
        if (rawUserSearchBase.isSet() && !rawUserObjectClass.isSet()) {
            throw new SecurityProviderCreationException("LDAP user group provider 'User Object Class' must be specified when 'User Search Base' is set.");
        }
        if (rawUserSearchBase.isSet() && !rawUserSearchScope.isSet()) {
            throw new SecurityProviderCreationException("LDAP user group provider 'User Search Scope' must be specified when 'User Search Base' is set.");
        }
        this.userSearchBase = rawUserSearchBase.getValue();
        this.userObjectClass = rawUserObjectClass.getValue();
        this.userSearchFilter = configurationContext.getProperty(PROP_USER_SEARCH_FILTER).getValue();
        this.userIdentityAttribute = configurationContext.getProperty(PROP_USER_IDENTITY_ATTRIBUTE).getValue();
        this.userGroupNameAttribute = configurationContext.getProperty(PROP_USER_GROUP_ATTRIBUTE).getValue();
        this.userGroupReferencedGroupAttribute = configurationContext.getProperty(PROP_USER_GROUP_REFERENCED_GROUP_ATTRIBUTE).getValue();
        try {
            this.userSearchScope = SearchScope.valueOf(rawUserSearchScope.getValue());
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized user search scope '%s'. Possible values are [%s]", rawUserSearchScope.getValue(), StringUtils.join((Object[])SearchScope.values(), (String)", ")));
        }
        this.useDnForUserIdentity = StringUtils.isBlank((CharSequence)this.userIdentityAttribute);
        this.performUserSearch = StringUtils.isNotBlank((CharSequence)this.userSearchBase);
        PropertyValue rawGroupSearchBase = configurationContext.getProperty(PROP_GROUP_SEARCH_BASE);
        PropertyValue rawGroupObjectClass = configurationContext.getProperty(PROP_GROUP_OBJECT_CLASS);
        PropertyValue rawGroupSearchScope = configurationContext.getProperty(PROP_GROUP_SEARCH_SCOPE);
        if (rawGroupSearchBase.isSet() && !rawGroupObjectClass.isSet()) {
            throw new SecurityProviderCreationException("LDAP user group provider 'Group Object Class' must be specified when 'Group Search Base' is set.");
        }
        if (rawGroupSearchBase.isSet() && !rawGroupSearchScope.isSet()) {
            throw new SecurityProviderCreationException("LDAP user group provider 'Group Search Scope' must be specified when 'Group Search Base' is set.");
        }
        this.groupSearchBase = rawGroupSearchBase.getValue();
        this.groupObjectClass = rawGroupObjectClass.getValue();
        this.groupSearchFilter = configurationContext.getProperty(PROP_GROUP_SEARCH_FILTER).getValue();
        this.groupNameAttribute = configurationContext.getProperty(PROP_GROUP_NAME_ATTRIBUTE).getValue();
        this.groupMemberAttribute = configurationContext.getProperty(PROP_GROUP_MEMBER_ATTRIBUTE).getValue();
        this.groupMemberReferencedUserAttribute = configurationContext.getProperty(PROP_GROUP_MEMBER_REFERENCED_USER_ATTRIBUTE).getValue();
        try {
            this.groupSearchScope = SearchScope.valueOf(rawGroupSearchScope.getValue());
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized group search scope '%s'. Possible values are [%s]", rawGroupSearchScope.getValue(), StringUtils.join((Object[])SearchScope.values(), (String)", ")));
        }
        this.useDnForGroupName = StringUtils.isBlank((CharSequence)this.groupNameAttribute);
        this.performGroupSearch = StringUtils.isNotBlank((CharSequence)this.groupSearchBase);
        if (!this.performUserSearch && !this.performGroupSearch) {
            throw new SecurityProviderCreationException("LDAP user group provider 'User Search Base' or 'Group Search Base' must be specified.");
        }
        if (this.performGroupSearch && !this.performUserSearch && StringUtils.isBlank((CharSequence)this.groupMemberAttribute)) {
            throw new SecurityProviderCreationException("'Group Member Attribute' is required when searching groups but not users.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupMemberReferencedUserAttribute) && !this.performUserSearch) {
            throw new SecurityProviderCreationException("''User Search Base' must be set when specifying 'Group Member Attribute - Referenced User Attribute'.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.userGroupReferencedGroupAttribute) && !this.performGroupSearch) {
            throw new SecurityProviderCreationException("'Group Search Base' must be set when specifying 'User Group Name Attribute - Referenced Group Attribute'.");
        }
        PropertyValue rawPageSize = configurationContext.getProperty(PROP_PAGE_SIZE);
        if (rawPageSize.isSet() && StringUtils.isNotBlank((CharSequence)rawPageSize.getValue())) {
            this.pageSize = rawPageSize.asInteger();
        }
        String rawGroupMembershipEnforceCaseSensitivity = configurationContext.getProperty(PROP_GROUP_MEMBERSHIP_ENFORCE_CASE_SENSITIVITY).getValue();
        this.groupMembershipEnforceCaseSensitivity = Boolean.parseBoolean(rawGroupMembershipEnforceCaseSensitivity);
        if (!baseEnvironment.isEmpty()) {
            context.setBaseEnvironmentProperties(baseEnvironment);
        }
        try {
            context.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new SecurityProviderCreationException(e.getMessage(), (Throwable)e);
        }
        PropertyValue rawSyncInterval = configurationContext.getProperty(PROP_SYNC_INTERVAL);
        if (rawSyncInterval.isSet()) {
            try {
                syncInterval = Math.round(FormatUtils.getPreciseTimeDuration((String)rawSyncInterval.getValue(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            catch (IllegalArgumentException iae) {
                throw new SecurityProviderCreationException(String.format("The %s '%s' is not a valid time duration", PROP_SYNC_INTERVAL, rawSyncInterval.getValue()));
            }
        } else {
            throw new SecurityProviderCreationException("The 'Sync Interval' must be specified.");
        }
        try {
            this.load((ContextSource)context);
            if (this.tenants.get() == null) {
                throw new SecurityProviderCreationException("Unable to sync users and groups.");
            }
            this.ldapSync.scheduleWithFixedDelay(() -> {
                block2: {
                    try {
                        this.load((ContextSource)context);
                    }
                    catch (Throwable t) {
                        logger.error("Failed to sync User/Groups from LDAP due to {}. Will try again in {} millis.", (Object)t, (Object)syncInterval);
                        if (!logger.isDebugEnabled()) break block2;
                        logger.error("", t);
                    }
                }
            }, syncInterval, syncInterval, TimeUnit.MILLISECONDS);
        }
        catch (AuthorizationAccessException e) {
            throw new SecurityProviderCreationException((Throwable)e);
        }
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.tenants.get().getAllUsers();
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        return this.tenants.get().getUsersById().get(identifier);
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        return this.tenants.get().getUser(identity);
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.tenants.get().getAllGroups();
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        return this.tenants.get().getGroupsById().get(identifier);
    }

    public UserAndGroups getUserAndGroups(final String identity) throws AuthorizationAccessException {
        final TenantHolder holder = this.tenants.get();
        return new UserAndGroups(){

            public User getUser() {
                return holder.getUser(identity);
            }

            public Set<Group> getGroups() {
                return holder.getGroups(identity);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ContextSource contextSource) {
        SingleContextSource singleContextSource = new SingleContextSource(contextSource.getReadOnlyContext());
        final LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)singleContextSource);
        try {
            final ArrayList userList = new ArrayList();
            ArrayList groupList = new ArrayList();
            final HashMap<String, Set> groupToUserIdentifierMappings = new HashMap<String, Set>();
            final HashMap userLookup = new HashMap();
            if (this.performUserSearch) {
                SearchControls userControls = new SearchControls();
                userControls.setSearchScope(this.userSearchScope.ordinal());
                Object userProcessor = this.pageSize == null ? new LdapTemplate.NullDirContextProcessor() : new PagedResultsDirContextProcessor(this.pageSize.intValue());
                AndFilter userFilter = new AndFilter();
                userFilter.and((Filter)new EqualsFilter("objectClass", this.userObjectClass));
                if (StringUtils.isNotBlank((CharSequence)this.userSearchFilter)) {
                    userFilter.and((Filter)new HardcodedFilter(this.userSearchFilter));
                }
                do {
                    userList.addAll(ldapTemplate.search(this.userSearchBase, userFilter.encode(), userControls, (ContextMapper)new AbstractContextMapper<User>(){

                        protected User doMapFromContext(DirContextOperations ctx) {
                            String identity = LdapUserGroupProvider.this.getUserIdentity(ctx);
                            User user = new User.Builder().identifierGenerateFromSeed(identity).identity(identity).build();
                            userLookup.put(LdapUserGroupProvider.this.getReferencedUserValue(ctx), user);
                            if (StringUtils.isNotBlank((CharSequence)LdapUserGroupProvider.this.userGroupNameAttribute)) {
                                Attribute attributeGroups = ctx.getAttributes().get(LdapUserGroupProvider.this.userGroupNameAttribute);
                                if (attributeGroups == null) {
                                    logger.debug("User group name attribute [{}] does not exist for {}. This may be due to misconfiguration or this user record may not have any group membership attributes defined. Ignoring group membership. ", (Object)LdapUserGroupProvider.this.userGroupNameAttribute, (Object)identity);
                                } else {
                                    try {
                                        NamingEnumeration<?> groupValues = attributeGroups.getAll();
                                        while (groupValues.hasMoreElements()) {
                                            String groupValue = (String)groupValues.next();
                                            String groupValueNormalized = LdapUserGroupProvider.this.performGroupSearch ? (LdapUserGroupProvider.this.groupMembershipEnforceCaseSensitivity ? groupValue : groupValue.toLowerCase()) : groupValue;
                                            groupToUserIdentifierMappings.computeIfAbsent(groupValueNormalized, g -> new HashSet()).add(user.getIdentifier());
                                        }
                                    }
                                    catch (NamingException e) {
                                        throw new AuthorizationAccessException("Error while retrieving user group name attribute [" + LdapUserGroupProvider.this.userIdentityAttribute + "].");
                                    }
                                }
                            }
                            return user;
                        }
                    }, (DirContextProcessor)userProcessor));
                } while (this.hasMorePages((DirContextProcessor)userProcessor));
            }
            if (this.performGroupSearch) {
                SearchControls groupControls = new SearchControls();
                groupControls.setSearchScope(this.groupSearchScope.ordinal());
                Object groupProcessor = this.pageSize == null ? new LdapTemplate.NullDirContextProcessor() : new PagedResultsDirContextProcessor(this.pageSize.intValue());
                AndFilter groupFilter = new AndFilter();
                groupFilter.and((Filter)new EqualsFilter("objectClass", this.groupObjectClass));
                if (StringUtils.isNotBlank((CharSequence)this.groupSearchFilter)) {
                    groupFilter.and((Filter)new HardcodedFilter(this.groupSearchFilter));
                }
                do {
                    groupList.addAll(ldapTemplate.search(this.groupSearchBase, groupFilter.encode(), groupControls, (ContextMapper)new AbstractContextMapper<Group>(){

                        protected Group doMapFromContext(DirContextOperations ctx) {
                            String name = LdapUserGroupProvider.this.getGroupName(ctx);
                            String referencedGroupValue = LdapUserGroupProvider.this.getReferencedGroupValue(ctx);
                            if (!StringUtils.isBlank((CharSequence)LdapUserGroupProvider.this.groupMemberAttribute)) {
                                Attribute attributeUsers = ctx.getAttributes().get(LdapUserGroupProvider.this.groupMemberAttribute);
                                if (attributeUsers == null) {
                                    logger.debug("Group member attribute [{}] does not exist for {}. This may be due to misconfiguration or this group record may not have any user attributes defined. Ignoring group membership.", (Object)LdapUserGroupProvider.this.groupMemberAttribute, (Object)name);
                                } else {
                                    try {
                                        NamingEnumeration<?> userValues = attributeUsers.getAll();
                                        while (userValues.hasMoreElements()) {
                                            String userValue = (String)userValues.next();
                                            if (LdapUserGroupProvider.this.performUserSearch) {
                                                String userValueNormalized = LdapUserGroupProvider.this.groupMembershipEnforceCaseSensitivity ? userValue : userValue.toLowerCase();
                                                User user = (User)userLookup.get(userValueNormalized);
                                                if (user != null) {
                                                    groupToUserIdentifierMappings.computeIfAbsent(referencedGroupValue, g -> new HashSet()).add(user.getIdentifier());
                                                    continue;
                                                }
                                                logger.debug("{} contains member {} but that user was not found while searching users. This may be due to misconfiguration or because that user is not a NiFi Registry user as defined by the User Search Base and Filter. Ignoring group membership.", (Object)name, (Object)userValue);
                                                continue;
                                            }
                                            String userDn = userValue;
                                            String userIdentity = LdapUserGroupProvider.this.useDnForUserIdentity ? LdapUserGroupProvider.this.identityMapper.mapUser(userDn) : LdapUserGroupProvider.this.getUserIdentity((DirContextOperations)((DirContextAdapter)ldapTemplate.lookup(userDn)));
                                            User user = new User.Builder().identifierGenerateFromSeed(userIdentity).identity(userIdentity).build();
                                            userList.add(user);
                                            groupToUserIdentifierMappings.computeIfAbsent(referencedGroupValue, g -> new HashSet()).add(user.getIdentifier());
                                        }
                                    }
                                    catch (NamingException e) {
                                        throw new AuthorizationAccessException("Error while retrieving group name attribute [" + LdapUserGroupProvider.this.groupNameAttribute + "].");
                                    }
                                }
                            }
                            Group.Builder groupBuilder = new Group.Builder().identifierGenerateFromSeed(name).name(name);
                            if (groupToUserIdentifierMappings.containsKey(referencedGroupValue)) {
                                ((Set)groupToUserIdentifierMappings.remove(referencedGroupValue)).forEach(arg_0 -> ((Group.Builder)groupBuilder).addUser(arg_0));
                            }
                            return groupBuilder.build();
                        }
                    }, (DirContextProcessor)groupProcessor));
                } while (this.hasMorePages((DirContextProcessor)groupProcessor));
                groupToUserIdentifierMappings.forEach((referencedGroupValue, userIdentifiers) -> logger.debug("[{}] are members of {} but that group was not found while searching groups. This may be due to misconfiguration or because that group is not a NiFi Registry group as defined by the Group Search Base and Filter. Ignoring group membership.", (Object)StringUtils.join((Iterable)userIdentifiers, (String)", "), referencedGroupValue));
            } else {
                groupToUserIdentifierMappings.forEach((groupDn, userIdentifiers) -> {
                    String groupName = this.useDnForGroupName ? this.identityMapper.mapGroup((String)groupDn) : this.getGroupName((DirContextOperations)((DirContextAdapter)ldapTemplate.lookup(groupDn)));
                    Group.Builder groupBuilder = new Group.Builder().identifierGenerateFromSeed(groupName).name(groupName);
                    userIdentifiers.forEach(arg_0 -> ((Group.Builder)groupBuilder).addUser(arg_0));
                    groupList.add(groupBuilder.build());
                });
            }
            if (logger.isDebugEnabled()) {
                logger.debug("-------------------------------------");
                logger.debug("Loaded the following users from LDAP:");
                userList.forEach(user -> logger.debug(" - {}", user));
                logger.debug("--------------------------------------");
                logger.debug("Loaded the following groups from LDAP:");
                groupList.forEach(group -> logger.debug(" - {}", group));
                logger.debug("--------------------------------------");
            }
            this.tenants.set(new TenantHolder(new HashSet<User>(userList), new HashSet<Group>(groupList)));
        }
        finally {
            singleContextSource.destroy();
        }
    }

    private boolean hasMorePages(DirContextProcessor processor) {
        return processor instanceof PagedResultsDirContextProcessor && ((PagedResultsDirContextProcessor)processor).hasMore();
    }

    private String getUserIdentity(DirContextOperations ctx) {
        String identity;
        if (this.useDnForUserIdentity) {
            identity = ctx.getDn().toString();
        } else {
            Attribute attributeName = ctx.getAttributes().get(this.userIdentityAttribute);
            if (attributeName == null) {
                throw new AuthorizationAccessException("User identity attribute [" + this.userIdentityAttribute + "] does not exist.");
            }
            try {
                identity = (String)attributeName.get();
            }
            catch (NamingException e) {
                throw new AuthorizationAccessException("Error while retrieving user name attribute [" + this.userIdentityAttribute + "].");
            }
        }
        return this.identityMapper.mapUser(identity);
    }

    private String getReferencedUserValue(DirContextOperations ctx) {
        String referencedUserValue;
        if (StringUtils.isBlank((CharSequence)this.groupMemberReferencedUserAttribute)) {
            referencedUserValue = ctx.getDn().toString();
        } else {
            Attribute attributeName = ctx.getAttributes().get(this.groupMemberReferencedUserAttribute);
            if (attributeName == null) {
                throw new AuthorizationAccessException("Referenced user value attribute [" + this.groupMemberReferencedUserAttribute + "] does not exist.");
            }
            try {
                referencedUserValue = (String)attributeName.get();
            }
            catch (NamingException e) {
                throw new AuthorizationAccessException("Error while retrieving reference user value attribute [" + this.groupMemberReferencedUserAttribute + "].");
            }
        }
        return this.groupMembershipEnforceCaseSensitivity ? referencedUserValue : referencedUserValue.toLowerCase();
    }

    private String getGroupName(DirContextOperations ctx) {
        String name;
        if (this.useDnForGroupName) {
            name = ctx.getDn().toString();
        } else {
            Attribute attributeName = ctx.getAttributes().get(this.groupNameAttribute);
            if (attributeName == null) {
                throw new AuthorizationAccessException("Group identity attribute [" + this.groupNameAttribute + "] does not exist.");
            }
            try {
                name = (String)attributeName.get();
            }
            catch (NamingException e) {
                throw new AuthorizationAccessException("Error while retrieving group name attribute [" + this.groupNameAttribute + "].");
            }
        }
        return this.identityMapper.mapGroup(name);
    }

    private String getReferencedGroupValue(DirContextOperations ctx) {
        String referencedGroupValue;
        if (StringUtils.isBlank((CharSequence)this.userGroupReferencedGroupAttribute)) {
            referencedGroupValue = ctx.getDn().toString();
        } else {
            Attribute attributeName = ctx.getAttributes().get(this.userGroupReferencedGroupAttribute);
            if (attributeName == null) {
                throw new AuthorizationAccessException("Referenced group value attribute [" + this.userGroupReferencedGroupAttribute + "] does not exist.");
            }
            try {
                referencedGroupValue = (String)attributeName.get();
            }
            catch (NamingException e) {
                throw new AuthorizationAccessException("Error while retrieving referenced group value attribute [" + this.userGroupReferencedGroupAttribute + "].");
            }
        }
        return this.groupMembershipEnforceCaseSensitivity ? referencedGroupValue : referencedGroupValue.toLowerCase();
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public final void preDestruction() throws SecurityProviderDestructionException {
        this.ldapSync.shutdown();
        try {
            if (!this.ldapSync.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                logger.info("Failed to stop ldap sync thread in 10 sec. Terminating");
                this.ldapSync.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void setTimeout(AuthorizerConfigurationContext configurationContext, Map<String, Object> baseEnvironment, String configurationProperty, String environmentKey) {
        PropertyValue rawTimeout = configurationContext.getProperty(configurationProperty);
        if (rawTimeout.isSet()) {
            try {
                long timeout = Math.round(FormatUtils.getPreciseTimeDuration((String)rawTimeout.getValue(), (TimeUnit)TimeUnit.MILLISECONDS));
                baseEnvironment.put(environmentKey, Long.toString(timeout));
            }
            catch (IllegalArgumentException iae) {
                throw new SecurityProviderCreationException(String.format("The %s '%s' is not a valid time duration", configurationProperty, rawTimeout));
            }
        }
    }

    private SSLContext getConfiguredSslContext(AuthorizerConfigurationContext configurationContext) {
        SSLContext sslContext;
        block16: {
            String rawKeystore = configurationContext.getProperty("TLS - Keystore").getValue();
            String rawKeystorePassword = configurationContext.getProperty("TLS - Keystore Password").getValue();
            String rawKeystoreType = configurationContext.getProperty("TLS - Keystore Type").getValue();
            String rawTruststore = configurationContext.getProperty("TLS - Truststore").getValue();
            String rawTruststorePassword = configurationContext.getProperty("TLS - Truststore Password").getValue();
            String rawTruststoreType = configurationContext.getProperty("TLS - Truststore Type").getValue();
            String rawProtocol = configurationContext.getProperty("TLS - Protocol").getValue();
            try {
                if (StringUtils.isBlank((CharSequence)rawKeystore) && StringUtils.isBlank((CharSequence)rawTruststore)) {
                    sslContext = null;
                    break block16;
                }
                if (StringUtils.isBlank((CharSequence)rawProtocol)) {
                    throw new SecurityProviderCreationException("TLS - Protocol must be specified.");
                }
                StandardSslContextBuilder sslContextBuilder = new StandardSslContextBuilder().protocol(rawProtocol);
                if (StringUtils.isNotBlank((CharSequence)rawTruststore)) {
                    try (FileInputStream trustStoreStream = new FileInputStream(rawTruststore);){
                        KeyStore trustStore = new StandardKeyStoreBuilder().type(rawTruststoreType).password(rawTruststorePassword.toCharArray()).inputStream((InputStream)trustStoreStream).build();
                        sslContextBuilder.trustStore(trustStore);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)rawKeystore)) {
                    try (FileInputStream keyStoreStream = new FileInputStream(rawKeystore);){
                        KeyStore keyStore = new StandardKeyStoreBuilder().type(rawKeystoreType).password(rawKeystorePassword.toCharArray()).inputStream((InputStream)keyStoreStream).build();
                        sslContextBuilder.keyStore(keyStore);
                        sslContextBuilder.keyPassword(rawKeystorePassword.toCharArray());
                    }
                }
                sslContext = sslContextBuilder.build();
            }
            catch (IOException | RuntimeException e) {
                throw new SecurityProviderCreationException(e.getMessage(), (Throwable)e);
            }
        }
        return sslContext;
    }
}

