/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.swap.Builder;

public class BuilderSwap<T, B> {
    private final Class<T> objectClass;
    private final Class<B> builderClass;
    private final Constructor<T> objectConstructor;
    private final Constructor<B> builderConstructor;
    private final MethodInfo createBuilderMethod;
    private final MethodInfo createObjectMethod;
    private ClassMeta<?> builderClassMeta;

    public static BuilderSwap<?, ?> findSwapFromBuilderClass(Class<?> builderClass, Visibility cVis, Visibility mVis) {
        ClassInfoTyped bci = ReflectionUtils.info(builderClass);
        if (bci.isNotPublic()) {
            return null;
        }
        Class objectClass = ReflectionUtils.info(builderClass).getParameterType(0, Builder.class);
        MethodInfo createObjectMethod = BuilderSwap.getBuilderBuildMethod((ClassInfo)bci);
        if (Utils.nn((Object)createObjectMethod)) {
            objectClass = createObjectMethod.getReturnType().inner();
        }
        if (objectClass == null) {
            return null;
        }
        ClassInfoTyped pci = ReflectionUtils.info((Class)objectClass);
        ConstructorInfo objectConstructor = pci.getDeclaredConstructor(x -> x.isVisible(cVis) && x.hasParameterTypes(new Class[]{builderClass})).orElse(null);
        if (objectConstructor == null) {
            return null;
        }
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis).orElse(null);
        MethodInfo createBuilderMethod = BuilderSwap.getBuilderCreateMethod((ClassInfo)pci);
        if (builderConstructor == null && createBuilderMethod == null) {
            return null;
        }
        return new BuilderSwap(objectClass, builderClass, objectConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), createBuilderMethod, createObjectMethod);
    }

    public static BuilderSwap<?, ?> findSwapFromObjectClass(BeanContext bc, Class<?> objectClass, Visibility cVis, Visibility mVis) {
        ConstructorInfo cc;
        Value builderClass = Value.empty();
        ConstructorInfo objectConstructor = null;
        ClassInfoTyped pci = ReflectionUtils.info(objectClass);
        bc.getAnnotationProvider().find(org.apache.juneau.annotation.Builder.class, (ClassInfo)pci, new AnnotationTraversal[0]).stream().map(x -> ((org.apache.juneau.annotation.Builder)x.inner()).value()).filter(ClassUtils::isNotVoid).forEach(x -> builderClass.set(x));
        MethodInfo builderCreateMethod = BuilderSwap.getBuilderCreateMethod((ClassInfo)pci);
        if (builderClass.isEmpty() && Utils.nn((Object)builderCreateMethod)) {
            builderClass.set((Object)builderCreateMethod.getReturnType().inner());
        }
        if (builderClass.isEmpty() && Utils.nn((Object)(cc = (ConstructorInfo)pci.getPublicConstructor(x -> x.isVisible(cVis) && x.hasNumParameters(1) && x.getParameter(0).getParameterType().isChildOf(Builder.class)).orElse(null)))) {
            objectConstructor = cc;
            builderClass.set((Object)cc.getParameter(0).getParameterType().inner());
        }
        if (builderClass.isEmpty()) {
            return null;
        }
        ClassInfoTyped bci = ReflectionUtils.info((Class)((Class)builderClass.get()));
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis).orElse(null);
        if (builderConstructor == null && builderCreateMethod == null) {
            return null;
        }
        MethodInfo objectCreateMethod = BuilderSwap.getBuilderBuildMethod((ClassInfo)bci);
        Class builderClass2 = (Class)builderClass.get();
        if (objectConstructor == null) {
            objectConstructor = pci.getDeclaredConstructor(x -> x.isVisible(cVis) && x.hasParameterTypes(new Class[]{builderClass2})).orElse(null);
        }
        if (objectConstructor == null && objectCreateMethod == null) {
            return null;
        }
        return new BuilderSwap(objectClass, (Class)builderClass.get(), objectConstructor == null ? null : objectConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), builderCreateMethod, objectCreateMethod);
    }

    private static MethodInfo getBuilderBuildMethod(ClassInfo c) {
        return c.getDeclaredMethod(x -> x.isNotStatic() && x.getParameterCount() == 0 && !x.hasReturnType(Void.TYPE) && x.hasName("build")).orElse(null);
    }

    private static MethodInfo getBuilderCreateMethod(ClassInfo c) {
        return c.getPublicMethod(x -> x.isStatic() && (x.hasName("create") || x.hasName("builder")) && !x.hasReturnType(c) && BuilderSwap.hasConstructorThatTakesType(c, x.getReturnType())).orElse(null);
    }

    private static boolean hasConstructorThatTakesType(ClassInfo c, ClassInfo argType) {
        return Utils.nn((Object)c.getPublicConstructor(x -> x.hasNumParameters(1) && x.hasParameterTypes(new ClassInfo[]{argType})));
    }

    protected BuilderSwap(Class<T> objectClass, Class<B> builderClass, Constructor<T> objectConstructor, Constructor<B> builderConstructor, MethodInfo createBuilderMethod, MethodInfo createObjectMethod) {
        this.objectClass = objectClass;
        this.builderClass = builderClass;
        this.objectConstructor = objectConstructor;
        this.builderConstructor = builderConstructor;
        this.createBuilderMethod = createBuilderMethod;
        this.createObjectMethod = createObjectMethod;
    }

    public T build(BeanSession session, B builder, ClassMeta<?> hint) throws ExecutableException {
        if (Utils.nn((Object)this.createObjectMethod)) {
            return (T)this.createObjectMethod.invoke(builder, new Object[0]);
        }
        try {
            return this.objectConstructor.newInstance(builder);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException((Throwable)e);
        }
    }

    public B create(BeanSession session, ClassMeta<?> hint) throws ExecutableException {
        if (Utils.nn((Object)this.createBuilderMethod)) {
            return (B)this.createBuilderMethod.invoke(null, new Object[0]);
        }
        try {
            return this.builderConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException((Throwable)e);
        }
    }

    public Class<B> getBuilderClass() {
        return this.builderClass;
    }

    public ClassMeta<?> getBuilderClassMeta(BeanSession session) {
        if (this.builderClassMeta == null) {
            this.builderClassMeta = session.getClassMeta(this.getBuilderClass());
        }
        return this.builderClassMeta;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }
}

