/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeVariables {
    private final Map<Class<?>, List<Class<?>>> map;

    public static TypeVariables empty() {
        return new TypeVariables(new LinkedHashMap());
    }

    public static TypeVariables of(Type type) {
        LinkedHashMap m = new LinkedHashMap();
        TypeVariables.findTypeVarImpls(type, m);
        return TypeVariables.fromMap(m);
    }

    private static void findTypeVarImpls(Type t, Map<Class<?>, List<Class<?>>> m) {
        ParameterizedType t2;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            TypeVariables.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                TypeVariables.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (t2 = (ParameterizedType)t).getRawType()) instanceof Class) {
            Class rt2 = (Class)rt;
            Type[] gImpls = t2.getActualTypeArguments();
            ArrayList<Class> gTypes = new ArrayList<Class>(gImpls.length);
            block1: for (Type gt : gImpls) {
                if (gt instanceof Class) {
                    Class c = (Class)gt;
                    gTypes.add(c);
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    Class upperBound2 = (Class)upperBound;
                    gTypes.add(upperBound2);
                    continue block1;
                }
            }
            m.put(rt2, gTypes);
            TypeVariables.findTypeVarImpls(t2.getRawType(), m);
        }
    }

    static TypeVariables fromMap(Map<Class<?>, List<Class<?>>> map) {
        return new TypeVariables(map);
    }

    TypeVariables(Map<Class<?>, List<Class<?>>> map) {
        this.map = map;
    }

    public boolean containsKey(Class<?> clazz) {
        return this.map.containsKey(clazz);
    }

    public List<Class<?>> get(Class<?> clazz) {
        return this.map.get(clazz);
    }

    public Class<?> get(Class<?> clazz, int index) {
        List<Class<?>> list = this.map.get(clazz);
        if (list == null || index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Class<?> resolve(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            Type gatct = gat.getGenericComponentType();
            if (gatct instanceof Class) {
                Class gatct2 = (Class)gatct;
                return Array.newInstance(gatct2, 0).getClass();
            }
            if (gatct instanceof ParameterizedType) {
                ParameterizedType gatct3 = (ParameterizedType)gatct;
                return Array.newInstance((Class)gatct3.getRawType(), 0).getClass();
            }
            if (gatct instanceof GenericArrayType) {
                GenericArrayType gatct4 = (GenericArrayType)gatct;
                Class<?> resolved = this.resolve(gatct4);
                return resolved != null ? Array.newInstance(resolved, 0).getClass() : null;
            }
            return null;
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            String varName = tv.getName();
            int varIndex = -1;
            Class gc = (Class)tv.getGenericDeclaration();
            TypeVariable<Class<T>>[] tvv = gc.getTypeParameters();
            for (int i = 0; i < tvv.length; ++i) {
                if (!tvv[i].getName().equals(varName)) continue;
                varIndex = i;
            }
            if (varIndex != -1) {
                return this.get(gc, varIndex);
            }
        }
        return null;
    }

    public static Class<?> resolve(Type type, TypeVariables typeVars) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type gatct = gat.getGenericComponentType();
            if (gatct instanceof Class) {
                Class gatct2 = (Class)gatct;
                return Array.newInstance(gatct2, 0).getClass();
            }
            if (gatct instanceof ParameterizedType) {
                ParameterizedType gatct3 = (ParameterizedType)gatct;
                return Array.newInstance((Class)gatct3.getRawType(), 0).getClass();
            }
            if (gatct instanceof GenericArrayType) {
                GenericArrayType gatct4 = (GenericArrayType)gatct;
                Class<?> resolved = TypeVariables.resolve(gatct4, typeVars);
                return resolved != null ? Array.newInstance(resolved, 0).getClass() : null;
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (typeVars == null) {
                return null;
            }
            return typeVars.resolve(tv);
        }
        return null;
    }
}

