/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.AMap;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = new AMap<String, String>().append("get", "0").append("put", "1").append("post", "2").append("delete", "3").append("options", "4").append("head", "5").append("patch", "6");

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(o1);
            String s2 = this.methods.get(o2);
            if (s1 == null) {
                s1 = o1;
            }
            if (s2 == null) {
                s2 = o2;
            }
            return StringUtils.compare(s1, s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(StringUtils.emptyIfNull(httpMethodName).toLowerCase(), operation);
        return this;
    }
}

