/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Loader {
    private Loader() {
    }

    public static Set<URL> getResources(String resource, ClassLoader classLoader) throws IOException {
        HashSet<URL> urlSet = new HashSet<URL>();
        Enumeration<URL> urlEnum = classLoader.getResources(resource);
        while (urlEnum.hasMoreElements()) {
            urlSet.add(urlEnum.nextElement());
        }
        return urlSet;
    }

    public static URL getResource(String resource, ClassLoader classLoader) {
        return classLoader.getResource(resource);
    }

    public static ClassLoader getClassLoaderOfObject(Object o) {
        if (o == null) {
            throw new NullPointerException("Input object cannot be null");
        }
        return Loader.getClassLoaderOfClass(o.getClass());
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }
}

