/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterLong
extends MutableCounter {
    private final LongAdder value = new LongAdder();

    public MutableCounterLong(MetricsInfo info, long initValue) {
        super(info);
        this.value.add(initValue);
    }

    @Override
    public void incr() {
        this.incr(1L);
    }

    public void incr(long delta) {
        this.value.add(delta);
        this.setChanged();
    }

    public long value() {
        return this.value.longValue();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value());
            this.clearChanged();
        }
    }
}

