/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basescheduler.spi.IBatchCallWeighter;
import org.apache.bifromq.basescheduler.spi.IBatchCallWeighterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchCallWeighterFactory
implements IBatchCallWeighterFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchCallWeighterFactory.class);
    public static final IBatchCallWeighterFactory INSTANCE = new BatchCallWeighterFactory();
    private final IBatchCallWeighterFactory delegate;

    private BatchCallWeighterFactory() {
        Map factoryMap = BaseHookLoader.load(IBatchCallWeighterFactory.class);
        if (factoryMap.isEmpty()) {
            this.delegate = FallbackFactory.INSTANCE;
        } else {
            this.delegate = (IBatchCallWeighterFactory)factoryMap.values().iterator().next();
            if (factoryMap.size() > 1) {
                log.warn("Multiple BatchCallWeigher implementations found, the first loaded will be used:{}", (Object)this.delegate.getClass().getName());
            }
        }
    }

    @Override
    public <ReqT> IBatchCallWeighter<ReqT> create(String name, Class<ReqT> reqType) {
        try {
            IBatchCallWeighter<ReqT> weighter = this.delegate.create(name, reqType);
            if (weighter == null) {
                return FallbackFactory.INSTANCE.create(name, reqType);
            }
            return weighter;
        }
        catch (Throwable e) {
            log.error("Failed to create BatchCallWeighter: scheduler={}", (Object)name, (Object)e);
            return FallbackFactory.INSTANCE.create(name, reqType);
        }
    }

    private static class FallbackFactory
    implements IBatchCallWeighterFactory {
        private static final IBatchCallWeighterFactory INSTANCE = new FallbackFactory();

        private FallbackFactory() {
        }

        @Override
        public <ReqT> IBatchCallWeighter<ReqT> create(String name, Class<ReqT> reqType) {
            return new FallbackWeighter();
        }
    }

    private static class FallbackWeighter<ReqT>
    implements IBatchCallWeighter<ReqT> {
        private int count = 0;

        private FallbackWeighter() {
        }

        @Override
        public void add(ReqT req) {
            ++this.count;
        }

        @Override
        public long weight() {
            return this.count;
        }

        @Override
        public void reset() {
            this.count = 0;
        }
    }
}

