/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.apache.bifromq.util.index.SingleEntryBranchTable;

final class EmptyBranchTable<V>
implements BranchTable<V> {
    private static final EmptyBranchTable INSTANCE = new EmptyBranchTable();

    private EmptyBranchTable() {
    }

    static <T> EmptyBranchTable<T> empty() {
        return INSTANCE;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Branch<V> get(String key) {
        return null;
    }

    @Override
    public BranchTable<V> plus(String key, Branch<V> value) {
        return new SingleEntryBranchTable<V>(key, value);
    }

    @Override
    public BranchTable<V> minus(String key) {
        return this;
    }

    @Override
    public void forEach(BiConsumer<String, Branch<V>> consumer) {
    }

    @Override
    public Map<String, Branch<V>> asMapView() {
        return Collections.emptyMap();
    }
}

