/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime.rtti;

import java.util.Arrays;
import java.util.Map;
import org.apache.calcite.runtime.rtti.RuntimeTypeInformation;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RowSqlTypeRtti
extends RuntimeTypeInformation {
    private final Map.Entry<String, RuntimeTypeInformation>[] fields;

    @SafeVarargs
    public RowSqlTypeRtti(Map.Entry<String, RuntimeTypeInformation> ... fields) {
        super(RuntimeTypeInformation.RuntimeSqlTypeName.ROW);
        this.fields = fields;
    }

    @Override
    public String getTypeString() {
        return "ROW";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("new RowSqlTypeRtti(");
        boolean first = true;
        for (Map.Entry<String, RuntimeTypeInformation> arg : this.fields) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append(arg.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSqlTypeRtti that = (RowSqlTypeRtti)o;
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public Map.Entry<String, RuntimeTypeInformation> getField(int index) {
        return this.fields[index];
    }

    public int size() {
        return this.fields.length;
    }

    public @Nullable RuntimeTypeInformation getFieldType(Object index) {
        if (index instanceof Integer) {
            int intIndex = (Integer)index;
            if (intIndex < 0 || intIndex >= this.fields.length) {
                return null;
            }
            return this.fields[intIndex].getValue();
        }
        if (index instanceof String) {
            String stringIndex = (String)index;
            for (Map.Entry<String, RuntimeTypeInformation> field : this.fields) {
                if (!field.getKey().equalsIgnoreCase(stringIndex)) continue;
                return field.getValue();
            }
        }
        return null;
    }
}

