/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.ignite.internal.jdbc.JdbcClientQueryCursorHandler;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcQueryExecuteResponse;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCancelResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class JdbcStatement
implements Statement {
    private static final int DFLT_PAGE_SIZE = 1024;
    protected final JdbcConnection conn;
    private final int resHoldability;
    private final String schema;
    private volatile boolean closed;
    long queryTimeoutMillis;
    private int maxRows;
    private int pageSize = 1024;
    private volatile List<@Nullable JdbcResultSet> resSets;
    private List<String> batch;
    private boolean closeOnCompletion;
    private int curRes;
    @Nullable
    private volatile Long lastCorrelationToken;

    JdbcStatement(JdbcConnection conn, int resHoldability, String schema) {
        assert (conn != null);
        this.conn = conn;
        this.resHoldability = resHoldability;
        this.schema = schema;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute0(JdbcStatementType.SELECT_STATEMENT_TYPE, Objects.requireNonNull(sql), false, ArrayUtils.OBJECT_EMPTY_ARRAY);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + sql, "42000");
        }
        return rs;
    }

    void execute0(JdbcStatementType stmtType, String sql, boolean multiStatement, Object[] args) throws SQLException {
        JdbcQueryExecuteResponse res;
        this.ensureNotClosed();
        this.closeResults();
        if (sql == null || sql.isEmpty()) {
            throw new SQLException("SQL query is empty.");
        }
        long correlationToken = this.nextToken();
        JdbcQueryExecuteRequest req = new JdbcQueryExecuteRequest(stmtType, this.schema, this.pageSize, this.maxRows, sql, args, this.conn.getAutoCommit(), multiStatement, this.queryTimeoutMillis, correlationToken, this.conn.observableTimestamp());
        try {
            res = (JdbcQueryExecuteResponse)this.conn.handler().queryAsync(this.conn.connectionId(), req).get();
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw JdbcStatement.toSqlException(e);
        }
        catch (CancellationException e) {
            throw new SQLException("Query execution canceled.", "57014", e);
        }
        if (!res.success()) {
            throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
        }
        JdbcQuerySingleResult executeResult = res.result();
        this.resSets = new ArrayList<JdbcResultSet>();
        JdbcClientQueryCursorHandler handler = new JdbcClientQueryCursorHandler(res.getChannel());
        List<JdbcColumnMeta> meta = executeResult.meta();
        Function<BinaryTupleReader, List<Object>> transformer = meta != null ? JdbcResultSet.createTransformer(meta) : null;
        int colCount = meta != null ? meta.size() : 0;
        this.resSets.add(new JdbcResultSet(handler, this, executeResult.cursorId(), this.pageSize, !executeResult.hasMoreData(), executeResult.items(), meta, executeResult.hasResultSet(), executeResult.hasNextResult(), executeResult.updateCount(), this.closeOnCompletion, colCount, transformer));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute0(JdbcStatementType.UPDATE_STATEMENT_TYPE, Objects.requireNonNull(sql), false, ArrayUtils.OBJECT_EMPTY_ARRAY);
        int res = this.getUpdateCount();
        if (res == -1) {
            this.closeResults();
            throw new SQLException("The query is not DML statement: " + sql);
        }
        return res;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.executeUpdate(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value");
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.closeResults();
            this.conn.removeStatement(this);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        if (max < 0) {
            throw new SQLException("Invalid field limit.");
        }
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        if (maxRows < 0) {
            throw new SQLException("Invalid max rows value.");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        long seconds = this.queryTimeoutMillis / 1000L;
        if (seconds >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.timeout((long)timeout * 1000L);
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        Long correlationToken = this.lastCorrelationToken;
        if (correlationToken == null) {
            return;
        }
        try {
            JdbcQueryCancelResult res = this.conn.handler().cancelAsync(this.conn.connectionId(), correlationToken).get();
            if (res.status() != 0) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
        }
        catch (CancellationException e) {
            throw new SQLException("Request to cancel the statement has been canceled.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Request to cancel the statement has failed.", e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.ensureNotClosed();
        this.execute0(JdbcStatementType.ANY_STATEMENT_TYPE, Objects.requireNonNull(sql), true, ArrayUtils.OBJECT_EMPTY_ARRAY);
        return this.isQuery();
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.execute(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value.");
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (colNames != null && colNames.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    @Nullable
    public ResultSet getResultSet() throws SQLException {
        this.ensureNotClosed();
        if (this.resSets == null || this.curRes >= this.resSets.size()) {
            return null;
        }
        @Nullable JdbcResultSet rs = this.resSets.get(this.curRes);
        if (rs == null || !rs.hasResultSet()) {
            return null;
        }
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureNotClosed();
        if (this.resSets == null || this.curRes >= this.resSets.size()) {
            return -1;
        }
        @Nullable JdbcResultSet rs = this.resSets.get(this.curRes);
        if (rs == null || rs.hasResultSet()) {
            return -1;
        }
        return (int)rs.updatedCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        JdbcResultSet nextResultSet;
        this.ensureNotClosed();
        if (this.resSets != null) {
            assert (this.curRes <= this.resSets.size()) : "Invalid results state: [resultsCount=" + this.resSets.size() + ", curRes=" + this.curRes + "]";
            switch (current) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    throw new SQLFeatureNotSupportedException("Multiple open results is not supported.");
                }
                default: {
                    throw new SQLException("Invalid 'current' parameter.");
                }
            }
        }
        if (this.resSets == null || this.curRes >= this.resSets.size() || this.resSets.get(this.curRes) == null) {
            return false;
        }
        SQLException exceptionally = null;
        try {
            nextResultSet = this.resSets.get(this.curRes).getNextResultSet();
        }
        catch (SQLException ex) {
            nextResultSet = null;
            exceptionally = ex;
        }
        this.resSets.add(nextResultSet);
        ++this.curRes;
        if (nextResultSet == null && this.isCloseOnCompletion()) {
            this.close();
            return false;
        }
        if (exceptionally != null) {
            throw exceptionally;
        }
        return nextResultSet != null && nextResultSet.holdResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.pageSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.pageSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(sql);
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        if (CollectionUtils.nullOrEmpty(this.batch)) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        long correlationToken = this.nextToken();
        JdbcBatchExecuteRequest req = new JdbcBatchExecuteRequest(this.conn.getSchema(), this.batch, this.conn.getAutoCommit(), this.queryTimeoutMillis, correlationToken);
        try {
            JdbcBatchExecuteResult res = this.conn.handler().batchAsync(this.conn.connectionId(), req).get();
            if (!res.success()) {
                throw new BatchUpdateException(res.err(), IgniteQueryErrorCode.codeToSqlState(res.getErrorCode()), res.getErrorCode(), res.updateCounts());
            }
            int[] nArray = res.updateCounts();
            return nArray;
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw JdbcStatement.toSqlException(e);
        }
        catch (CancellationException e) {
            throw new SQLException("Batch execution canceled.", "57014");
        }
        finally {
            this.batch = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.resHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed() || this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureNotClosed();
        this.closeOnCompletion = true;
        if (this.resSets != null) {
            for (JdbcResultSet rs : this.resSets) {
                if (rs == null) continue;
                rs.closeStatement(true);
            }
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(Objects.requireNonNull(iface))) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcStatement.class);
    }

    protected boolean isQuery() {
        return Objects.requireNonNull(this.resSets).get(0).hasResultSet();
    }

    void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
    }

    void closeResults() throws SQLException {
        @Nullable JdbcResultSet last = null;
        if (this.resSets != null) {
            boolean allFetched;
            JdbcResultSet lastRs = this.resSets.get(this.resSets.size() - 1);
            boolean bl = allFetched = lastRs == null || lastRs.isClosed() && !lastRs.holdsResources();
            if (allFetched) {
                for (JdbcResultSet rs : this.resSets) {
                    if (rs == null) continue;
                    rs.close0(true);
                }
            } else {
                for (last = lastRs.getNextResultSet(); last != null; last = last.getNextResultSet()) {
                }
            }
            this.resSets = null;
            this.curRes = 0;
        }
        this.lastCorrelationToken = null;
    }

    void closeIfAllResultsClosed() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        boolean allRsClosed = true;
        if (this.resSets != null) {
            for (JdbcResultSet rs : this.resSets) {
                if (rs == null || rs.isClosed()) continue;
                allRsClosed = false;
                break;
            }
        }
        if (allRsClosed) {
            this.close();
        }
    }

    public final void timeout(long timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0L) {
            throw new SQLException("Invalid timeout value.");
        }
        this.queryTimeoutMillis = timeout;
    }

    long nextToken() {
        long correlationToken = this.conn.nextToken();
        this.lastCorrelationToken = correlationToken;
        return correlationToken;
    }

    private static SQLException toSqlException(ExecutionException e) {
        return new SQLException(e);
    }
}

