/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroup;

public class IgniteCheckedException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final String groupName;
    private final int code;
    private final UUID traceId;

    public IgniteCheckedException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteCheckedException(UUID traceId, int code) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, null));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteCheckedException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteCheckedException(UUID traceId, int code, String message) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, (String)message));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteCheckedException(int code, Throwable cause) {
        this(UUID.randomUUID(), code, cause);
    }

    public IgniteCheckedException(UUID traceId, int code, Throwable cause) {
        super(ErrorGroup.errorMessageFromCause((UUID)traceId, (int)code, (Throwable)cause), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public IgniteCheckedException(int code, String message, Throwable cause) {
        this(UUID.randomUUID(), code, message, cause);
    }

    public IgniteCheckedException(UUID traceId, int code, String message, Throwable cause) {
        super(ErrorGroup.errorMessage((UUID)traceId, (int)code, (String)message), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode((int)ErrorGroup.extractGroupCode((int)code)).name();
        this.code = code;
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return "IGN-" + this.groupName() + "-" + this.errorCode();
    }

    public int groupCode() {
        return ErrorGroup.extractGroupCode((int)this.code);
    }

    public int errorCode() {
        return ErrorGroup.extractErrorCode((int)this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }
}

