/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;

public interface IgniteSingleSetOp
extends IgniteSetOp {
    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        boolean rewindable = inputTraits.stream().map(TraitUtils::rewindability).allMatch(RewindabilityTrait::rewindable);
        if (rewindable) {
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.REWINDABLE), inputTraits));
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.ONE_WAY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RewindabilityTrait.ONE_WAY))));
    }

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits) == IgniteDistributions.single()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
        }
        return null;
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        boolean single = inputTraits.stream().map(TraitUtils::distribution).allMatch(d -> d.satisfies((RelTrait)IgniteDistributions.single()));
        if (!single) {
            return List.of();
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), inputTraits));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> correlationIds = inTraits.stream().map(TraitUtils::correlation).flatMap(corrTr -> corrTr.correlationIds().stream()).collect(Collectors.toSet());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(correlationIds)), inTraits));
    }

    @Override
    default public AggregateType aggregateType() {
        return AggregateType.SINGLE;
    }
}

