/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.Objects;

public class CacheKey {
    private final String schemaName;
    private final String query;
    private final Object contextKey;

    public CacheKey(String schemaName, String query, Object contextKey) {
        this.schemaName = schemaName;
        this.query = query;
        this.contextKey = contextKey;
    }

    public CacheKey(String schemaName, String query) {
        this(schemaName, query, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        if (!this.schemaName.equals(cacheKey.schemaName)) {
            return false;
        }
        if (!this.query.equals(cacheKey.query)) {
            return false;
        }
        return Objects.equals(this.contextKey, cacheKey.contextKey);
    }

    public int hashCode() {
        int result = this.schemaName.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.contextKey != null ? this.contextKey.hashCode() : 0);
        return result;
    }
}

