/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.function.Function;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.CollectionUtils;

public class ProjectNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final Function<RowT, RowT> prj;

    public ProjectNode(ExecutionContext<RowT> ctx, RelDataType rowType, Function<RowT, RowT> prj) {
        super(ctx, rowType);
        this.prj = prj;
    }

    @Override
    protected void rewindInternal() {
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        this.checkState();
        this.source().request(rowsCnt);
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        this.checkState();
        this.downstream().push(this.prj.apply(row));
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        this.checkState();
        this.downstream().end();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

