/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class AsyncSqlCursorImpl<T>
implements AsyncSqlCursor<T> {
    private final SqlQueryType queryType;
    private final ResultSetMetadata meta;
    @Nullable
    private final InternalTransaction implicitTx;
    private final AsyncCursor<T> dataCursor;

    public AsyncSqlCursorImpl(SqlQueryType queryType, ResultSetMetadata meta, @Nullable InternalTransaction implicitTx, AsyncCursor<T> dataCursor) {
        this.queryType = queryType;
        this.meta = meta;
        this.implicitTx = implicitTx;
        this.dataCursor = dataCursor;
    }

    @Override
    public SqlQueryType queryType() {
        return this.queryType;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        return this.dataCursor.requestNextAsync(rows).handle((batch, t) -> {
            if (t != null) {
                if (this.implicitTx != null) {
                    this.implicitTx.rollback();
                }
                throw IgniteException.wrap((Throwable)t);
            }
            if (this.implicitTx != null && !batch.hasMore()) {
                this.implicitTx.commit();
            }
            return batch;
        });
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.dataCursor.closeAsync();
    }
}

