/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.rest;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.rest.api.cluster.ClusterNodeDto;
import org.apache.ignite.internal.rest.api.cluster.NetworkAddressDto;
import org.apache.ignite.internal.rest.api.cluster.TopologyApi;
import org.apache.ignite.internal.rest.exception.ClusterNotInitializedException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.TopologyService;

@Controller(value="/management/v1/cluster/topology")
public class TopologyController
implements TopologyApi {
    private final TopologyService topologyService;
    private final ClusterManagementGroupManager cmgManager;

    public TopologyController(TopologyService topologyService, ClusterManagementGroupManager cmgManager) {
        this.topologyService = topologyService;
        this.cmgManager = cmgManager;
    }

    public Collection<ClusterNodeDto> physicalTopology() {
        return TopologyController.toClusterNodeDtos(this.topologyService.allMembers());
    }

    public CompletableFuture<Collection<ClusterNodeDto>> logicalTopology() {
        return ((CompletableFuture)this.cmgManager.clusterState().thenCompose(state -> {
            if (state == null) {
                throw new ClusterNotInitializedException();
            }
            return this.cmgManager.logicalTopology();
        })).thenApply(TopologyController::toClusterNodeDtos);
    }

    private static List<ClusterNodeDto> toClusterNodeDtos(Collection<ClusterNode> nodes) {
        return nodes.stream().map(TopologyController::toClusterNodeDto).collect(Collectors.toList());
    }

    private static ClusterNodeDto toClusterNodeDto(ClusterNode node) {
        NetworkAddress addr = node.address();
        NetworkAddressDto addrDto = new NetworkAddressDto(addr.host(), addr.port(), addr.consistentId());
        return new ClusterNodeDto(node.id(), node.name(), addrDto);
    }
}

