/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.lang.ErrorGroups;

public class StatementResult {
    private final byte[] result;

    public StatementResult(byte[] result) {
        this.result = result;
    }

    public StatementResult(boolean result) {
        this.result = new byte[]{(byte)(result ? 1 : 0)};
    }

    public StatementResult(int result) {
        this.result = ByteBuffer.allocate(4).putInt(result).array();
    }

    public boolean getAsBoolean() {
        if (this.result.length != 1) {
            throw new ResultConversionException("Result can't be interpreted as boolean");
        }
        return this.result[0] != 0;
    }

    public Integer getAsInt() {
        if (this.result.length != 4) {
            throw new ResultConversionException("Result can't be interpreted as int");
        }
        return ByteBuffer.wrap(this.result).getInt();
    }

    public byte[] bytes() {
        return this.result;
    }

    public static class ResultConversionException
    extends MetaStorageException {
        public ResultConversionException(String msg) {
            super(ErrorGroups.MetaStorage.OP_EXECUTION_ERR, msg);
        }
    }
}

