/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.NodeMetrics;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LocalStorageOutter;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RaftException;
import org.apache.ignite.raft.jraft.option.RaftMetaStorageOptions;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.RaftMetaStorage;
import org.apache.ignite.raft.jraft.storage.io.MessageFile;
import org.apache.ignite.raft.jraft.util.Utils;

public class LocalRaftMetaStorage
implements RaftMetaStorage {
    private static final IgniteLogger LOG = Loggers.forClass(LocalRaftMetaStorage.class);
    private static final String RAFT_META = "raft_meta";
    private boolean isInited;
    private final String path;
    private long term;
    private PeerId votedFor = PeerId.emptyPeer();
    private final RaftOptions raftOptions;
    private NodeMetrics nodeMetrics;
    private NodeImpl node;

    public LocalRaftMetaStorage(String path, RaftOptions raftOptions) {
        this.path = path;
        this.raftOptions = raftOptions;
    }

    @Override
    public boolean init(RaftMetaStorageOptions opts) {
        if (this.isInited) {
            LOG.warn("Raft meta storage is already inited.", new Object[0]);
            return true;
        }
        this.node = opts.getNode();
        this.nodeMetrics = this.node.getNodeMetrics();
        File dir = new File(this.path);
        if (!Utils.mkdir(dir)) {
            LOG.error("Fail to mkdir {}", new Object[]{this.path});
            return false;
        }
        if (this.load()) {
            this.isInited = true;
            return true;
        }
        return false;
    }

    private boolean load() {
        MessageFile pbFile = this.newPbFile();
        try {
            LocalStorageOutter.StablePBMeta meta = (LocalStorageOutter.StablePBMeta)pbFile.load();
            if (meta != null) {
                this.term = meta.term();
                return this.votedFor.parse(meta.votedFor());
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            LOG.error("Fail to load raft meta storage", (Throwable)e);
            return false;
        }
    }

    private MessageFile newPbFile() {
        return new MessageFile(this.path + File.separator + RAFT_META);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        boolean bl;
        long start;
        block9: {
            start = Utils.monotonicMs();
            LocalStorageOutter.StablePBMeta meta = this.raftOptions.getRaftMessagesFactory().stablePBMeta().term(this.term).votedFor(this.votedFor.toString()).build();
            MessageFile pbFile = this.newPbFile();
            if (pbFile.save(meta, this.raftOptions.isSyncMeta())) break block9;
            this.reportIOError();
            boolean bl2 = false;
            long cost = Utils.monotonicMs() - start;
            if (this.nodeMetrics != null) {
                this.nodeMetrics.recordLatency("save-raft-meta", cost);
            }
            LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                LOG.error("Fail to save raft meta", (Throwable)e);
                this.reportIOError();
                bl3 = false;
            }
            catch (Throwable throwable) {
                long cost = Utils.monotonicMs() - start;
                if (this.nodeMetrics != null) {
                    this.nodeMetrics.recordLatency("save-raft-meta", cost);
                }
                LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
                throw throwable;
            }
            long cost = Utils.monotonicMs() - start;
            if (this.nodeMetrics != null) {
                this.nodeMetrics.recordLatency("save-raft-meta", cost);
            }
            LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
            return bl3;
        }
        long cost = Utils.monotonicMs() - start;
        if (this.nodeMetrics != null) {
            this.nodeMetrics.recordLatency("save-raft-meta", cost);
        }
        LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
        return bl;
    }

    private void reportIOError() {
        this.node.onError(new RaftException(EnumOutter.ErrorType.ERROR_TYPE_META, RaftError.EIO, "Fail to save raft meta, path=%s", this.path));
    }

    @Override
    public void shutdown() {
        if (!this.isInited) {
            return;
        }
        this.save();
        this.isInited = false;
    }

    private void checkState() {
        if (!this.isInited) {
            throw new IllegalStateException("LocalRaftMetaStorage not initialized");
        }
    }

    @Override
    public boolean setTerm(long term) {
        this.checkState();
        this.term = term;
        return this.save();
    }

    @Override
    public long getTerm() {
        this.checkState();
        return this.term;
    }

    @Override
    public boolean setVotedFor(PeerId peerId) {
        this.checkState();
        this.votedFor = peerId;
        return this.save();
    }

    @Override
    public PeerId getVotedFor() {
        this.checkState();
        return this.votedFor;
    }

    @Override
    public boolean setTermAndVotedFor(long term, PeerId peerId) {
        this.checkState();
        this.votedFor = peerId;
        this.term = term;
        return this.save();
    }

    public String toString() {
        return "RaftMetaStorageImpl [path=" + this.path + ", term=" + this.term + ", votedFor=" + this.votedFor + "]";
    }
}

