/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.expression;

import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;

public class Query
implements AnnotationValue {
    private final AnnotationValue condition;
    private final AnnotationValue trueExpression;
    private final AnnotationValue falseExpression;

    public Query(AnnotationValue condition, AnnotationValue trueExpression, AnnotationValue falseExpression) {
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    public AnnotationValue getCondition() {
        return this.condition;
    }

    public AnnotationValue getTrueExpression() {
        return this.trueExpression;
    }

    public AnnotationValue getFalseExpression() {
        return this.falseExpression;
    }

    @Override
    public String getParameterValue() {
        return this.condition.getParameterValue().toString() + " ? " + this.trueExpression.getParameterValue() + " : " + this.falseExpression.getParameterValue();
    }

    public String toString() {
        return this.condition.toString() + " ? " + this.trueExpression.toString() + " : " + this.falseExpression.toString();
    }
}

