/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class TaskInformation
implements Serializable {
    private static final long serialVersionUID = -9006218793155953789L;
    private final JobVertexID jobVertexId;
    private final String taskName;
    private final int numberOfSubtasks;
    private final int maxNumberOfSubtasks;
    private final String invokableClassName;
    private final Configuration taskConfiguration;

    public TaskInformation(JobVertexID jobVertexId, String taskName, int numberOfSubtasks, int maxNumberOfSubtasks, String invokableClassName, Configuration taskConfiguration) {
        this.jobVertexId = Preconditions.checkNotNull(jobVertexId);
        this.taskName = Preconditions.checkNotNull(taskName);
        this.numberOfSubtasks = numberOfSubtasks;
        this.maxNumberOfSubtasks = maxNumberOfSubtasks;
        this.invokableClassName = Preconditions.checkNotNull(invokableClassName);
        this.taskConfiguration = Preconditions.checkNotNull(taskConfiguration);
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public int getMaxNumberOfSubtasks() {
        return this.maxNumberOfSubtasks;
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }
}

