/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.theta.HashIterator;

final class BytesCompactHashIterator
implements HashIterator {
    private final byte[] bytes;
    private final int offset;
    private final int numEntries;
    private int index;

    BytesCompactHashIterator(byte[] bytes, int offset, int numEntries) {
        this.bytes = bytes;
        this.offset = offset;
        this.numEntries = numEntries;
        this.index = -1;
    }

    @Override
    public long get() {
        return ByteArrayUtil.getLongLE(this.bytes, this.offset + this.index * 8);
    }

    @Override
    public boolean next() {
        return ++this.index < this.numEntries;
    }
}

