/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;

public interface MemorySegmentRequest {
    public static final Default DEFAULT = new Default();

    default public MemorySegment request(long newByteSize) {
        if (newByteSize > Integer.MAX_VALUE) {
            throw new SketchesArgumentException("Requested size in bytes exceeds Integer.MAX_VALUE.");
        }
        return MemorySegment.ofArray(new byte[(int)newByteSize]);
    }

    default public void requestClose(MemorySegment prevSeg) {
    }

    public static class Default
    implements MemorySegmentRequest {
    }
}

