/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;

public abstract class DiscoveryService
implements ActiveMQComponent {
    private Listener listener;

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void fireEntryAddedEvent(Entry entry) {
        if (this.listener != null) {
            this.listener.entryAdded(entry);
        }
    }

    protected void fireEntryRemovedEvent(Entry entry) {
        if (this.listener != null) {
            this.listener.entryRemoved(entry);
        }
    }

    protected void fireEntryUpdatedEvent(Entry oldEntry, Entry newEntry) {
        if (this.listener != null) {
            this.listener.entryUpdated(oldEntry, newEntry);
        }
    }

    public static interface Listener {
        public void entryAdded(Entry var1);

        public void entryRemoved(Entry var1);

        public void entryUpdated(Entry var1, Entry var2);
    }

    public class Entry {
        private final String nodeID;
        private final TransportConfiguration connector;

        public String getNodeID() {
            return this.nodeID;
        }

        public TransportConfiguration getConnector() {
            return this.connector;
        }

        public Entry(String nodeID, TransportConfiguration connector) {
            this.nodeID = nodeID;
            this.connector = connector;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Entry.class.getSimpleName());
            stringBuilder.append("(nodeID=" + this.nodeID);
            stringBuilder.append(", connector=" + String.valueOf(this.connector));
            stringBuilder.append(") ");
            return stringBuilder.toString();
        }
    }
}

