/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.Random;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.ContinuousOutputModel;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.TestProblem3;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math3.ode.sampling.DummyStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContinuousOutputModelTest {
    TestProblem3 pb = null;
    FirstOrderIntegrator integ = null;

    @Test
    public void testBoundaries() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.integ.addStepHandler((StepHandler)new ContinuousOutputModel());
        this.integ.integrate((FirstOrderDifferentialEquations)this.pb, this.pb.getInitialTime(), this.pb.getInitialState(), this.pb.getFinalTime(), new double[this.pb.getDimension()]);
        ContinuousOutputModel cm = (ContinuousOutputModel)this.integ.getStepHandlers().iterator().next();
        cm.setInterpolatedTime(2.0 * this.pb.getInitialTime() - this.pb.getFinalTime());
        cm.setInterpolatedTime(2.0 * this.pb.getFinalTime() - this.pb.getInitialTime());
        cm.setInterpolatedTime(0.5 * (this.pb.getFinalTime() + this.pb.getInitialTime()));
    }

    @Test
    public void testRandomAccess() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        ContinuousOutputModel cm = new ContinuousOutputModel();
        this.integ.addStepHandler((StepHandler)cm);
        this.integ.integrate((FirstOrderDifferentialEquations)this.pb, this.pb.getInitialTime(), this.pb.getInitialState(), this.pb.getFinalTime(), new double[this.pb.getDimension()]);
        Random random = new Random(347588535632L);
        double maxError = 0.0;
        double maxErrorDot = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double r = random.nextDouble();
            double time = r * this.pb.getInitialTime() + (1.0 - r) * this.pb.getFinalTime();
            cm.setInterpolatedTime(time);
            double[] interpolatedY = cm.getInterpolatedState();
            double[] interpolatedYDot = cm.getInterpolatedDerivatives();
            double[] theoreticalY = this.pb.computeTheoreticalState(time);
            double[] theoreticalYDot = new double[this.pb.getDimension()];
            this.pb.doComputeDerivatives(time, theoreticalY, theoreticalYDot);
            double dx = interpolatedY[0] - theoreticalY[0];
            double dy = interpolatedY[1] - theoreticalY[1];
            double error = dx * dx + dy * dy;
            maxError = FastMath.max((double)maxError, (double)error);
            double dxDot = interpolatedYDot[0] - theoreticalYDot[0];
            double dyDot = interpolatedYDot[1] - theoreticalYDot[1];
            double errorDot = dxDot * dxDot + dyDot * dyDot;
            maxErrorDot = FastMath.max((double)maxErrorDot, (double)errorDot);
        }
        Assert.assertEquals((double)0.0, (double)maxError, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)maxErrorDot, (double)4.0E-7);
    }

    @Test
    public void testModelsMerging() throws MaxCountExceededException, MathIllegalArgumentException {
        FirstOrderDifferentialEquations problem = new FirstOrderDifferentialEquations(){

            public void computeDerivatives(double t, double[] y, double[] dot) {
                dot[0] = -y[1];
                dot[1] = y[0];
            }

            public int getDimension() {
                return 2;
            }
        };
        ContinuousOutputModel cm1 = new ContinuousOutputModel();
        DormandPrince853Integrator integ1 = new DormandPrince853Integrator(0.0, 1.0, 1.0E-8, 1.0E-8);
        integ1.addStepHandler((StepHandler)cm1);
        integ1.integrate(problem, Math.PI, new double[]{-1.0, 0.0}, 0.0, new double[2]);
        ContinuousOutputModel cm2 = new ContinuousOutputModel();
        DormandPrince853Integrator integ2 = new DormandPrince853Integrator(0.0, 0.1, 1.0E-12, 1.0E-12);
        integ2.addStepHandler((StepHandler)cm2);
        integ2.integrate(problem, Math.PI * 2, new double[]{1.0, 0.0}, Math.PI, new double[2]);
        ContinuousOutputModel cm = new ContinuousOutputModel();
        cm.append(cm2);
        cm.append(new ContinuousOutputModel());
        cm.append(cm1);
        Assert.assertEquals((double)(Math.PI * 2), (double)cm.getInitialTime(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)cm.getFinalTime(), (double)1.0E-12);
        Assert.assertEquals((double)cm.getFinalTime(), (double)cm.getInterpolatedTime(), (double)1.0E-12);
        for (double t = 0.0; t < Math.PI * 2; t += 0.1) {
            cm.setInterpolatedTime(t);
            double[] y = cm.getInterpolatedState();
            Assert.assertEquals((double)FastMath.cos((double)t), (double)y[0], (double)1.0E-7);
            Assert.assertEquals((double)FastMath.sin((double)t), (double)y[1], (double)1.0E-7);
        }
    }

    @Test
    public void testErrorConditions() throws MaxCountExceededException, MathIllegalArgumentException {
        ContinuousOutputModel cm = new ContinuousOutputModel();
        cm.handleStep(this.buildInterpolator(0.0, new double[]{0.0, 1.0, -2.0}, 1.0), true);
        Assert.assertTrue((boolean)this.checkAppendError(cm, 1.0, new double[]{0.0, 1.0}, 2.0));
        Assert.assertTrue((boolean)this.checkAppendError(cm, 10.0, new double[]{0.0, 1.0, -2.0}, 20.0));
        Assert.assertTrue((boolean)this.checkAppendError(cm, 1.0, new double[]{0.0, 1.0, -2.0}, 0.0));
        Assert.assertFalse((boolean)this.checkAppendError(cm, 1.0, new double[]{0.0, 1.0, -2.0}, 2.0));
    }

    private boolean checkAppendError(ContinuousOutputModel cm, double t0, double[] y0, double t1) throws MaxCountExceededException, MathIllegalArgumentException {
        try {
            ContinuousOutputModel otherCm = new ContinuousOutputModel();
            otherCm.handleStep(this.buildInterpolator(t0, y0, t1), true);
            cm.append(otherCm);
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
        return false;
    }

    private StepInterpolator buildInterpolator(double t0, double[] y0, double t1) {
        DummyStepInterpolator interpolator = new DummyStepInterpolator(y0, new double[y0.length], t1 >= t0);
        interpolator.storeTime(t0);
        interpolator.shift();
        interpolator.storeTime(t1);
        return interpolator;
    }

    public void checkValue(double value, double reference) {
        Assert.assertTrue((FastMath.abs((double)(value - reference)) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Before
    public void setUp() {
        this.pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = this.pb.getFinalTime() - this.pb.getInitialTime();
        this.integ = new DormandPrince54Integrator(minStep, maxStep, 1.0E-8, 1.0E-8);
    }

    @After
    public void tearDown() {
        this.pb = null;
        this.integ = null;
    }
}

