/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.issues;

import java.util.HashMap;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JXPath172DynamicTest
extends AbstractJXPathTest {
    private JXPathContext getContext(String val, boolean lenient) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", val);
        HashMap<String, String> target = map;
        JXPathContext context = JXPathContext.newContext(null, target);
        context.setLenient(lenient);
        return context;
    }

    @Test
    public void testIssue172_nestedpropertyDoesNotExist_Lenient() {
        JXPathContext context = this.getContext(null, true);
        Object bRet = context.selectSingleNode("value.unexisting");
        Assertions.assertNull((Object)bRet);
        Pointer pointer = context.getPointer("value.unexisting");
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_nestedpropertyDoesNotExist_NotLenient() {
        JXPathContext context = this.getContext(null, false);
        Object bRet = context.selectSingleNode("value.unexisting");
        Assertions.assertNull((Object)bRet);
        Pointer pointer = context.getPointer("value.unexisting");
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyDoesNotExist() {
        JXPathContext context = this.getContext(null, false);
        Object bRet = context.selectSingleNode("unexisting");
        Assertions.assertNull((Object)bRet);
        Pointer pointer = context.getPointer("unexisting");
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyDoesNotExist_Lenient() {
        JXPathContext context = this.getContext(null, true);
        Object bRet = context.selectSingleNode("unexisting");
        Assertions.assertNull((Object)bRet);
        Pointer pointer = context.getPointer("unexisting");
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyExistAndIsNotNull() {
        JXPathContext context = this.getContext("ciao", false);
        Object bRet = context.selectSingleNode("value");
        Assertions.assertNotNull((Object)bRet, (String)"null!!");
        Assertions.assertEquals((Object)"ciao", (Object)bRet, (String)("Is " + bRet.getClass()));
        Pointer pointer = context.getPointer("value");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertEquals((Object)"ciao", (Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyExistAndIsNull() {
        JXPathContext context = this.getContext(null, false);
        Object bRet = context.selectSingleNode("value");
        Assertions.assertNull((Object)bRet, (String)"not null!!");
        Pointer pointer = context.getPointer("value");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(DynamicPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }
}

