/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import org.apache.commons.io.serialization.WildcardClassNameMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WildcardClassNameMatcherTest {
    WildcardClassNameMatcherTest() {
    }

    @Test
    void testNoPattern() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org.foo");
        Assertions.assertTrue((boolean)ca.matches("org.foo"));
        Assertions.assertFalse((boolean)ca.matches("org.foo.and.more"));
        Assertions.assertFalse((boolean)ca.matches("org_foo"));
    }

    @Test
    void testStar() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org*");
        Assertions.assertTrue((boolean)ca.matches("org.foo.should.match"));
        Assertions.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }

    @Test
    void testStarAndQuestionMark() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org?apache?something*");
        Assertions.assertTrue((boolean)ca.matches("org.apache_something.more"));
        Assertions.assertFalse((boolean)ca.matches("org..apache_something.more"));
    }
}

