/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class PathUtilsContentEqualsTest {
    @TempDir
    public File temporaryFolder;

    PathUtilsContentEqualsTest() {
    }

    static Configuration[] testConfigurations() {
        return new Configuration[]{Configuration.osX().toBuilder().setWorkingDirectory("/").build(), Configuration.unix().toBuilder().setWorkingDirectory("/").build(), Configuration.windows().toBuilder().setWorkingDirectory("C:\\").build()};
    }

    private void assertContentEquals(FileSystem fileSystem1, FileSystem fileSystem2) throws IOException {
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem1, (FileSystem)fileSystem2));
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem2, (FileSystem)fileSystem1));
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem1, (FileSystem)fileSystem1));
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem2, (FileSystem)fileSystem2));
    }

    private void assertContentNotEquals(FileSystem fileSystem1, FileSystem fileSystem2) throws IOException {
        Assertions.assertFalse((boolean)PathUtils.contentEquals((FileSystem)fileSystem1, (FileSystem)fileSystem2));
        Assertions.assertFalse((boolean)PathUtils.contentEquals((FileSystem)fileSystem2, (FileSystem)fileSystem1));
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem1, (FileSystem)fileSystem1));
        Assertions.assertTrue((boolean)PathUtils.contentEquals((FileSystem)fileSystem2, (FileSystem)fileSystem2));
    }

    private void assertDirectoryAndFileContentEquals(Path dir1, Path dir2) throws IOException {
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
    }

    private void assertDirectoryAndFileContentNotEquals(Path dir1, Path dir2) throws IOException {
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
    }

    private void assertFileContentEquals(Path path1, Path path2) throws IOException {
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path1));
    }

    private void assertFileContentNotEquals(Path path1, Path path2) throws IOException {
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path2));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path2));
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    @ParameterizedTest
    @MethodSource(value={"testConfigurations"})
    void testContentEqualsFileSystemsMemVsMem(Configuration configuration) throws Exception {
        Path refDir = Paths.get("src/test/resources/dir-equals-tests", new String[0]);
        try (FileSystem fileSystem1 = Jimfs.newFileSystem((Configuration)configuration);
             FileSystem fileSystem2 = Jimfs.newFileSystem((Configuration)configuration);){
            Path fsDir1 = fileSystem1.getPath(refDir.getFileName().toString(), new String[0]);
            Path fsDir2 = fileSystem2.getPath(refDir.getFileName().toString(), new String[0]);
            Assertions.assertTrue((PathUtils.copyDirectory((Path)refDir, (Path)fsDir1, (CopyOption[])new CopyOption[0]).getByteCounter().get() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((PathUtils.copyDirectory((Path)refDir, (Path)fsDir2, (CopyOption[])new CopyOption[0]).getByteCounter().get() > 0L ? 1 : 0) != 0);
            this.assertContentEquals(fileSystem1, fileSystem2);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testConfigurations"})
    void testContentEqualsFileSystemsMemVsZip(Configuration configuration) throws Exception {
        Path refDir = Paths.get("src/test/resources/dir-equals-tests", new String[0]);
        try (FileSystem fileSystem1 = Jimfs.newFileSystem((Configuration)configuration);
             FileSystem fileSystem2 = FileSystems.newFileSystem(refDir.resolveSibling(refDir.getFileName() + ".zip"), null);){
            Path fsDir1 = fileSystem1.getPath(refDir.getFileName().toString(), new String[0]);
            Counters.PathCounters copyDirectory = PathUtils.copyDirectory((Path)refDir, (Path)fsDir1, (CopyOption[])new CopyOption[0]);
            Assertions.assertTrue((copyDirectory.getByteCounter().get() > 0L ? 1 : 0) != 0);
            this.assertContentEquals(fileSystem1, fileSystem2);
        }
    }

    @Test
    void testContentEqualsFileSystemsZipVsZip() throws Exception {
        FileSystem fileSystem2;
        Path zipPath = Paths.get("src/test/resources/dir-equals-tests.zip", new String[0]);
        Path zipCopy = this.temporaryFolder.toPath().resolve("copy2.zip");
        Files.copy(zipPath, zipCopy, StandardCopyOption.REPLACE_EXISTING);
        try (FileSystem fileSystem1 = FileSystems.newFileSystem(zipPath, null);
             FileSystem fileSystem22 = FileSystems.newFileSystem(zipCopy, null);){
            this.assertContentEquals(fileSystem1, fileSystem22);
        }
        Path emptyZip = Paths.get("src/test/resources/org/apache/commons/io/empty.zip", new String[0]);
        try (FileSystem fileSystem1 = FileSystems.newFileSystem(emptyZip, null);){
            fileSystem2 = FileSystems.newFileSystem(emptyZip, null);
            try {
                this.assertContentEquals(fileSystem1, fileSystem2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        fileSystem1 = FileSystems.newFileSystem(zipCopy, null);
        try {
            fileSystem2 = FileSystems.newFileSystem(emptyZip, null);
            try {
                this.assertContentNotEquals(fileSystem1, fileSystem2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        finally {
            if (fileSystem1 != null) {
                fileSystem1.close();
            }
        }
        fileSystem1 = FileSystems.newFileSystem(zipPath, null);
        try {
            fileSystem2 = FileSystems.newFileSystem(emptyZip, null);
            try {
                this.assertContentNotEquals(fileSystem1, fileSystem2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        finally {
            if (fileSystem1 != null) {
                fileSystem1.close();
            }
        }
    }

    @Test
    void testDirectoryAndFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        this.assertDirectoryAndFileContentEquals(null, null);
        this.assertDirectoryAndFileContentNotEquals(path1, null);
        this.assertDirectoryAndFileContentEquals(path1, path2);
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        this.assertDirectoryAndFileContentEquals(dir1, dir2);
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        this.assertDirectoryAndFileContentEquals(dir1, dir2);
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        this.assertDirectoryAndFileContentEquals(dir1, dir2);
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        this.assertDirectoryAndFileContentNotEquals(dir1, dir2);
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        this.assertDirectoryAndFileContentNotEquals(dir1, dir2);
    }

    @Test
    void testDirectoryAndFileContentEqualsDifferentFileSystemsFileVsZip() throws Exception {
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests", new String[0]);
        try (FileSystem fileSystem = FileSystems.newFileSystem(dir1.resolveSibling(dir1.getFileName() + ".zip"), null);){
            Path dir2 = fileSystem.getPath("/dir-equals-tests", new String[0]);
            this.assertDirectoryAndFileContentEquals(dir1, dir2);
        }
    }

    @Test
    void testDirectoryAndFileContentEqualsDifferentFileSystemsZipVsZip() throws Exception {
        Path zipPath = Paths.get("src/test/resources/dir-equals-tests.zip", new String[0]);
        Path zipCopy = this.temporaryFolder.toPath().resolve("copy1.zip");
        Files.copy(zipPath, zipCopy, StandardCopyOption.REPLACE_EXISTING);
        try (FileSystem fileSystem1 = FileSystems.newFileSystem(zipPath, null);
             FileSystem fileSystem2 = FileSystems.newFileSystem(zipCopy, null);){
            Path dir1 = fileSystem1.getPath("/dir-equals-tests", new String[0]);
            Path dir2 = fileSystem2.getPath("/dir-equals-tests", new String[0]);
            this.assertDirectoryAndFileContentEquals(dir1, dir2);
        }
    }

    @Test
    void testDirectoryAndFileContentEqualsDifferentFileSystemsZipVsZipEmpty() throws Exception {
        Path dir2;
        Path dir1;
        FileSystem fileSystem2;
        Path zipPath = Paths.get("src/test/resources/dir-equals-tests.zip", new String[0]);
        Path zipCopy = this.temporaryFolder.toPath().resolve("copy1.zip");
        Path emptyZip = Paths.get("src/test/resources/org/apache/commons/io/empty.zip", new String[0]);
        Files.copy(zipPath, zipCopy, StandardCopyOption.REPLACE_EXISTING);
        try (FileSystem fileSystem1 = FileSystems.newFileSystem(zipPath, null);){
            fileSystem2 = FileSystems.newFileSystem(emptyZip, null);
            try {
                dir1 = fileSystem1.getPath("/dir-equals-tests", new String[0]);
                dir2 = fileSystem2.getPath("/", new String[0]);
                this.assertDirectoryAndFileContentNotEquals(dir1, dir2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        fileSystem1 = FileSystems.newFileSystem(zipPath, null);
        try {
            fileSystem2 = FileSystems.newFileSystem(emptyZip, null);
            try {
                dir1 = fileSystem1.getPath("/dir-equals-tests", new String[0]);
                dir2 = fileSystem2.getRootDirectories().iterator().next();
                this.assertDirectoryAndFileContentNotEquals(dir1, dir2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        finally {
            if (fileSystem1 != null) {
                fileSystem1.close();
            }
        }
        Files.copy(emptyZip, zipCopy, StandardCopyOption.REPLACE_EXISTING);
        fileSystem1 = FileSystems.newFileSystem(emptyZip, null);
        try {
            fileSystem2 = FileSystems.newFileSystem(zipCopy, null);
            try {
                dir1 = fileSystem1.getPath("/", new String[0]);
                dir2 = fileSystem2.getPath("/", new String[0]);
                this.assertDirectoryAndFileContentEquals(dir1, dir2);
            }
            finally {
                if (fileSystem2 != null) {
                    fileSystem2.close();
                }
            }
        }
        finally {
            if (fileSystem1 != null) {
                fileSystem1.close();
            }
        }
    }

    @Test
    void testDirectoryContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(null, (Path)path1));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)path1, null));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path1, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path2, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path2, (Path)path1));
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir1));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir1));
    }

    @Test
    void testFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(null, null));
        this.assertFileContentNotEquals(path1, null);
        this.assertFileContentEquals(path1, path2);
        Assertions.assertThrows(IOException.class, () -> PathUtils.fileContentEquals((Path)this.temporaryFolder.toPath(), (Path)this.temporaryFolder.toPath()));
        Path objFile1 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object");
        PathUtils.copyFile((URL)this.getClass().getResource("/java/lang/Object.class"), (Path)objFile1, (CopyOption[])new CopyOption[0]);
        Path objFile1b = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object2");
        PathUtils.copyFile((URL)this.getClass().getResource("/java/lang/Object.class"), (Path)objFile1b, (CopyOption[])new CopyOption[0]);
        Path objFile2 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".collection");
        PathUtils.copyFile((URL)this.getClass().getResource("/java/util/Collection.class"), (Path)objFile2, (CopyOption[])new CopyOption[0]);
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile2));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)objFile1b, (Path)objFile2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1b, (Path)objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile2, (Path)objFile2));
        Files.createFile(path1, new FileAttribute[0]);
        Files.createFile(path2, new FileAttribute[0]);
        this.assertFileContentEquals(path1, path2);
    }

    @Test
    void testFileContentEqualsZip() throws Exception {
        Path path1 = Paths.get("src/test/resources/org/apache/commons/io/bla.zip", new String[0]);
        Path path2 = Paths.get("src/test/resources/org/apache/commons/io/bla-copy.zip", new String[0]);
        Path path3 = Paths.get("src/test/resources/org/apache/commons/io/moby.zip", new String[0]);
        this.assertFileContentEquals(path1, path2);
        this.assertFileContentNotEquals(path1, path3);
    }

    @Test
    void testFileContentEqualsZipFileSystem() throws Exception {
        try (FileSystem fileSystem = FileSystems.newFileSystem(Paths.get("src/test/resources/org/apache/commons/io/test-same-size-diff-contents.zip", new String[0]), ClassLoader.getSystemClassLoader());){
            Path path1 = fileSystem.getPath("/test-same-size-diff-contents/A.txt", new String[0]);
            Path path2 = fileSystem.getPath("/test-same-size-diff-contents/B.txt", new String[0]);
            Assertions.assertTrue((boolean)Files.exists(path1, new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(path2, new LinkOption[0]));
            this.assertFileContentNotEquals(path1, path2);
        }
    }
}

