/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.xml.IncludeTableHandler;
import org.apache.cayenne.dbsync.xml.SchemaHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class CatalogHandler
extends NamespaceAwareNestedTagHandler {
    private static final String CATALOG_TAG = "catalog";
    private static final String CATALOG_NAME_TAG = "name";
    private static final String SCHEMA_TAG = "schema";
    private static final String INCLUDE_TABLE_TAG = "includeTable";
    private static final String EXCLUDE_TABLE_TAG = "excludeTable";
    private static final String INCLUDE_COLUMN_TAG = "includeColumn";
    private static final String EXCLUDE_COLUMN_TAG = "excludeColumn";
    private static final String INCLUDE_PROCEDURE_TAG = "includeProcedure";
    private static final String EXCLUDE_PROCEDURE_TAG = "excludeProcedure";
    private ReverseEngineering configuration;
    private Catalog catalog;

    CatalogHandler(NamespaceAwareNestedTagHandler parentHandler, ReverseEngineering configuration) {
        super(parentHandler);
        this.configuration = configuration;
    }

    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI.equals(this.targetNamespace)) {
            switch (localName) {
                case "schema": {
                    return new SchemaHandler(this, this.catalog);
                }
                case "includeTable": {
                    return new IncludeTableHandler(this, this.catalog);
                }
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "catalog": {
                this.createCatalog();
                return true;
            }
        }
        return false;
    }

    protected boolean processCharData(String localName, String data) {
        switch (localName) {
            case "includeTable": {
                this.createIncludeTable(data);
                break;
            }
            case "name": {
                this.createCatalogName(data);
                break;
            }
            case "excludeTable": {
                this.createExcludeTable(data);
                break;
            }
            case "includeColumn": {
                this.createIncludeColumn(data);
                break;
            }
            case "excludeColumn": {
                this.createExcludeColumn(data);
                break;
            }
            case "includeProcedure": {
                this.createIncludeProcedure(data);
                break;
            }
            case "excludeProcedure": {
                this.createExcludeProcedure(data);
            }
        }
        return true;
    }

    private void createIncludeTable(String includeTableData) {
        if (includeTableData.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            IncludeTable includeTable = new IncludeTable();
            includeTable.setName(includeTableData);
            this.catalog.addIncludeTable(includeTable);
        }
    }

    private void createCatalogName(String catalogName) {
        if (catalogName.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.setName(catalogName);
        }
    }

    private void createExcludeProcedure(String excludeProcedure) {
        if (excludeProcedure.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.addExcludeProcedure(new ExcludeProcedure(excludeProcedure));
        }
    }

    private void createIncludeProcedure(String includeProcedure) {
        if (includeProcedure.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.addIncludeProcedure(new IncludeProcedure(includeProcedure));
        }
    }

    private void createExcludeColumn(String excludeColumn) {
        if (excludeColumn.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
    }

    private void createIncludeColumn(String includeColumn) {
        if (includeColumn.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.addIncludeColumn(new IncludeColumn(includeColumn));
        }
    }

    private void createExcludeTable(String excludeTable) {
        if (excludeTable.trim().length() == 0) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.addExcludeTable(new ExcludeTable(excludeTable));
        }
    }

    private void createCatalog() {
        this.catalog = new Catalog();
        this.configuration.addCatalog(this.catalog);
    }
}

