/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.sql.Connection;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.query.ProcedureQuery;

class PostgresProcedureAction
extends SQLServerProcedureAction {
    PostgresProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(query, dataNode);
    }

    @Override
    protected ProcedureTranslator createTranslator(Connection connection) {
        PostgresProcedureTranslator translator = new PostgresProcedureTranslator();
        translator.setAdapter(this.dataNode.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.dataNode.getEntityResolver());
        translator.setConnection(connection);
        translator.setJdbcEventLogger(this.dataNode.getJdbcEventLogger());
        return translator;
    }

    static class PostgresProcedureTranslator
    extends ProcedureTranslator {
        PostgresProcedureTranslator() {
        }

        @Override
        protected String createSqlString() {
            Object sql = super.createSqlString();
            if (((String)sql).endsWith("}") && !((String)sql).endsWith(")}")) {
                sql = ((String)sql).substring(0, ((String)sql).length() - 1) + "()}";
            }
            return sql;
        }
    }
}

