/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.wocompat;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.wocompat.EODbAttribute;
import org.apache.cayenne.wocompat.EOModelHelper;
import org.apache.cayenne.wocompat.EOObjAttribute;
import org.apache.cayenne.wocompat.EOObjEntity;
import org.apache.cayenne.wocompat.EOQuery;
import org.apache.cayenne.wocompat.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EOModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EOModelProcessor.class);
    protected Predicate<String> prototypeChecker = entityName -> {
        if (entityName == null) {
            return false;
        }
        return entityName.startsWith("EO") && entityName.endsWith("Prototypes");
    };

    public Map loadModeIndex(URL url) throws Exception {
        String urlString = url.toExternalForm();
        if (!urlString.endsWith(".eomodeld")) {
            url = new URL(urlString + ".eomodeld");
        }
        Parser plistParser = new Parser();
        try (InputStream in = new URL(url, "index.eomodeld").openStream();){
            plistParser.ReInit(in);
            Map map = (Map)plistParser.propertyList();
            return map;
        }
    }

    public DataMap loadEOModel(URL url) throws Exception {
        return this.loadEOModel(url, false);
    }

    public DataMap loadEOModel(URL url, boolean generateClientClass) throws Exception {
        EOModelHelper helper = this.makeHelper(url);
        DataMap dataMap = helper.getDataMap();
        List<Object> modelNames = new ArrayList(helper.modelNamesAsList());
        modelNames = modelNames.stream().filter(this.prototypeChecker.negate()).collect(Collectors.toList());
        modelNames.forEach(name -> this.makeEntity(helper, (String)name, generateClientClass));
        modelNames.sort(new InheritanceComparator(dataMap));
        for (String string : modelNames) {
            EOObjEntity e = (EOObjEntity)dataMap.getObjEntity(string);
            this.makeAttributes(helper, e);
        }
        for (String string : modelNames) {
            this.makeRelationships(helper, dataMap.getObjEntity(string));
        }
        for (String string : modelNames) {
            this.makeFlatRelationships(helper, dataMap.getObjEntity(string));
        }
        for (String string : modelNames) {
            DbEntity dbEntity = dataMap.getObjEntity(string).getDbEntity();
            if (dbEntity == null) continue;
            this.makeReverseDbRelationships(dbEntity);
        }
        for (String string : modelNames) {
            Iterator queries = helper.queryNames(string);
            while (queries.hasNext()) {
                String queryName = (String)queries.next();
                EOObjEntity entity = (EOObjEntity)dataMap.getObjEntity(string);
                this.makeQuery(helper, entity, queryName);
            }
        }
        return dataMap;
    }

    protected boolean isPrototypesEntity(String entityName) {
        return this.prototypeChecker.test(entityName);
    }

    protected EOModelHelper makeHelper(URL url) throws Exception {
        return new EOModelHelper(url);
    }

    protected QueryDescriptor makeQuery(EOModelHelper helper, EOObjEntity entity, String queryName) {
        DataMap dataMap = helper.getDataMap();
        Map queryPlist = helper.queryPListMap(entity.getName(), queryName);
        if (queryPlist == null) {
            return null;
        }
        QueryDescriptor query = queryPlist.containsKey("hints") ? this.makeEOSQLQueryDescriptor(entity, queryPlist) : this.makeEOQueryDescriptor(entity, queryPlist);
        query.setName(entity.qualifiedQueryName(queryName));
        dataMap.addQueryDescriptor(query);
        return query;
    }

    protected QueryDescriptor makeEOQueryDescriptor(ObjEntity root, Map plistMap) {
        List prefetches;
        Map qualifierMap;
        List orderings;
        SelectQueryDescriptor descriptor = QueryDescriptor.selectQueryDescriptor();
        descriptor.setRoot(root);
        descriptor.setDistinct("YES".equalsIgnoreCase((String)plistMap.get("usesDistinct")));
        Object fetchLimit = plistMap.get("fetchLimit");
        if (fetchLimit != null) {
            try {
                if (fetchLimit instanceof Number) {
                    descriptor.setProperty("cayenne.GenericSelectQuery.fetchLimit", String.valueOf(((Number)fetchLimit).intValue()));
                } else if (EOModelProcessor.isNumeric(fetchLimit.toString())) {
                    descriptor.setProperty("cayenne.GenericSelectQuery.fetchLimit", fetchLimit.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((orderings = (List)plistMap.get("sortOrderings")) != null && !orderings.isEmpty()) {
            for (Map ordering : orderings) {
                boolean asc;
                boolean bl = asc = !"compareDescending:".equals(ordering.get("selectorName"));
                String key = (String)ordering.get("key");
                if (key == null) continue;
                descriptor.addOrdering(new Ordering(key, asc ? SortOrder.ASCENDING : SortOrder.DESCENDING));
            }
        }
        if ((qualifierMap = (Map)plistMap.get("qualifier")) != null && !qualifierMap.isEmpty()) {
            descriptor.setQualifier(EOQuery.EOFetchSpecificationParser.makeQualifier((EOObjEntity)root, qualifierMap));
        }
        if ((prefetches = (List)plistMap.get("prefetchingRelationshipKeyPaths")) != null && !prefetches.isEmpty()) {
            Iterator it = prefetches.iterator();
            while (it.hasNext()) {
                descriptor.addPrefetch((String)it.next(), 1);
            }
        }
        if (plistMap.containsKey("rawRowKeyPaths")) {
            descriptor.setProperty("cayenne.GenericSelectQuery.fetchingDataRows", String.valueOf(true));
        }
        return descriptor;
    }

    protected QueryDescriptor makeEOSQLQueryDescriptor(ObjEntity root, Map plistMap) {
        String sqlExpression;
        Map hints;
        SQLTemplateDescriptor descriptor = QueryDescriptor.sqlTemplateDescriptor();
        descriptor.setRoot(root);
        Object fetchLimit = plistMap.get("fetchLimit");
        if (fetchLimit != null) {
            try {
                if (fetchLimit instanceof Number) {
                    descriptor.setProperty("cayenne.GenericSelectQuery.fetchLimit", String.valueOf(((Number)fetchLimit).intValue()));
                } else if (EOModelProcessor.isNumeric(fetchLimit.toString())) {
                    descriptor.setProperty("cayenne.GenericSelectQuery.fetchLimit", fetchLimit.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((hints = (Map)plistMap.get("hints")) != null && !hints.isEmpty() && (sqlExpression = (String)hints.get("EOCustomQueryExpressionHintKey")) != null) {
            descriptor.setSql(sqlExpression);
        }
        return descriptor;
    }

    protected EOObjEntity makeEntity(EOModelHelper helper, String name, boolean generateClientClass) {
        DataMap dataMap = helper.getDataMap();
        Map entityPlist = helper.entityPListMap(name);
        EOObjEntity objEntity = new EOObjEntity(name);
        objEntity.setEoMap(entityPlist);
        String parent = (String)entityPlist.get("parent");
        objEntity.setClassName(helper.entityClass(name, generateClientClass));
        if (parent != null) {
            objEntity.setSubclass(true);
            objEntity.setSuperClassName(helper.entityClass(parent, generateClientClass));
        }
        objEntity.setAbstractEntity("Y".equals(entityPlist.get("isAbstractEntity")));
        Object dbEntityName = (String)entityPlist.get("externalName");
        if (dbEntityName != null) {
            boolean createDbEntity = true;
            if (parent != null) {
                Map parentData;
                String parentName = parent;
                while (parentName != null && (parentData = helper.entityPListMap(parentName)) != null) {
                    String parentExternalName = (String)parentData.get("externalName");
                    if (parentExternalName == null) {
                        parentName = (String)parentData.get("parent");
                        continue;
                    }
                    if (!((String)dbEntityName).equals(parentExternalName)) break;
                    createDbEntity = false;
                    break;
                }
            }
            if (createDbEntity) {
                int i = 0;
                String dbEntityBaseName = dbEntityName;
                while (dataMap.getDbEntity((String)dbEntityName) != null) {
                    dbEntityName = dbEntityBaseName + i++;
                }
                objEntity.setDbEntityName((String)dbEntityName);
                DbEntity de = new DbEntity((String)dbEntityName);
                dataMap.addDbEntity(de);
            }
        }
        objEntity.setReadOnly("Y".equals(entityPlist.get("isReadOnly")));
        objEntity.setSuperEntityName((String)entityPlist.get("parent"));
        dataMap.addObjEntity(objEntity);
        return objEntity;
    }

    private static boolean externalTypeIsClob(String type) {
        if (type == null) {
            return false;
        }
        return "CLOB".equalsIgnoreCase(type) || "TEXT".equalsIgnoreCase(type);
    }

    protected void makeAttributes(EOModelHelper helper, EOObjEntity objEntity) {
        Map parentData;
        Map entityPlistMap = helper.entityPListMap(objEntity.getName());
        List primaryKeys = (List)entityPlistMap.get("primaryKeyAttributes");
        List classProperties = (List)entityPlistMap.get("classProperties");
        List attributes = (List)entityPlistMap.get("attributes");
        DbEntity dbEntity = objEntity.getDbEntity();
        if (primaryKeys == null) {
            primaryKeys = Collections.EMPTY_LIST;
        }
        if (classProperties == null) {
            classProperties = Collections.EMPTY_LIST;
        }
        if (attributes == null) {
            attributes = Collections.EMPTY_LIST;
        }
        boolean singleTableInheritance = false;
        String parentName = (String)entityPlistMap.get("parent");
        while (parentName != null && (parentData = helper.entityPListMap(parentName)) != null) {
            String parentExternalName = (String)parentData.get("externalName");
            if (parentExternalName == null) {
                parentName = (String)parentData.get("parent");
                continue;
            }
            if (dbEntity.getName() == null || !dbEntity.getName().equals(parentExternalName)) break;
            singleTableInheritance = true;
            break;
        }
        for (Map attrMap : attributes) {
            String prototypeName = (String)attrMap.get("prototypeName");
            Map prototypeAttrMap = helper.getPrototypeAttributeMapFor(prototypeName);
            Object dbAttrName = this.getStringValueFromMap("columnName", attrMap, prototypeAttrMap);
            String attrName = this.getStringValueFromMap("name", attrMap, prototypeAttrMap);
            String attrType = this.getStringValueFromMap("valueClassName", attrMap, prototypeAttrMap);
            String valueType = this.getStringValueFromMap("valueType", attrMap, prototypeAttrMap);
            String externalType = this.getStringValueFromMap("externalType", attrMap, prototypeAttrMap);
            String javaType = helper.javaTypeForEOModelerType(attrType, valueType);
            EODbAttribute dbAttr = null;
            if (!(dbAttrName == null || dbEntity == null || singleTableInheritance && dbEntity.getAttribute((String)dbAttrName) != null)) {
                Object allowsNull;
                int scale;
                int i = 0;
                String dbAttributeBaseName = dbAttrName;
                while (dbEntity.getAttribute((String)dbAttrName) != null) {
                    dbAttrName = dbAttributeBaseName + i++;
                }
                int sqlType = TypesMapping.getSqlTypeByJava(javaType);
                int width = this.getInt("width", attrMap, prototypeAttrMap, -1);
                if (sqlType == 12 && width < 0 && EOModelProcessor.externalTypeIsClob(externalType)) {
                    sqlType = 2005;
                } else if (sqlType == Integer.MAX_VALUE && externalType != null) {
                    sqlType = TypesMapping.getSqlTypeByName(externalType.toUpperCase());
                }
                dbAttr = new EODbAttribute((String)dbAttrName, sqlType, dbEntity);
                dbAttr.setEoAttributeName(attrName);
                dbEntity.addAttribute(dbAttr);
                if (width >= 0) {
                    dbAttr.setMaxLength(width);
                }
                if ((scale = this.getInt("scale", attrMap, prototypeAttrMap, -1)) >= 0) {
                    dbAttr.setScale(scale);
                }
                if (primaryKeys.contains(attrName)) {
                    dbAttr.setPrimaryKey(true);
                }
                dbAttr.setMandatory(!"Y".equals(allowsNull = attrMap.get("allowsNull")));
            }
            if (!classProperties.contains(attrName)) continue;
            EOObjAttribute attr = new EOObjAttribute(attrName, javaType, objEntity);
            String entityReadOnlyString = (String)entityPlistMap.get("isReadOnly");
            String attributeReadOnlyString = (String)attrMap.get("isReadOnly");
            if ("Y".equals(entityReadOnlyString) || "Y".equals(attributeReadOnlyString)) {
                attr.setReadOnly(true);
            }
            attr.setDbAttributePath((String)dbAttrName);
            objEntity.addAttribute(attr);
        }
    }

    private String getStringValueFromMap(String key, Map attrMap, Map prototypeAttrMap) {
        String dbAttrName = (String)attrMap.get(key);
        if (null == dbAttrName) {
            dbAttrName = (String)prototypeAttrMap.get(key);
        }
        return dbAttrName;
    }

    int getInt(String key, Map map, Map prototypes, int defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            value = prototypes.get(key);
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    protected void makeRelationships(EOModelHelper helper, ObjEntity objEntity) {
        Map entityPlistMap = helper.entityPListMap(objEntity.getName());
        List classProps = (List)entityPlistMap.get("classProperties");
        List rinfo = (List)entityPlistMap.get("relationships");
        Collection attributes = (Collection)entityPlistMap.get("attributes");
        if (rinfo == null) {
            return;
        }
        if (classProps == null) {
            classProps = Collections.EMPTY_LIST;
        }
        if (attributes == null) {
            attributes = Collections.EMPTY_LIST;
        }
        DbEntity dbSrc = objEntity.getDbEntity();
        for (Map relMap : rinfo) {
            String targetName = (String)relMap.get("destination");
            if (targetName == null) continue;
            String relName = (String)relMap.get("name");
            boolean toMany = "Y".equals(relMap.get("isToMany"));
            boolean toDependentPK = "Y".equals(relMap.get("propagatesPrimaryKey"));
            ObjEntity target = helper.getDataMap().getObjEntity(targetName);
            if (target == null) continue;
            DbEntity dbTarget = target.getDbEntity();
            Map targetPlistMap = helper.entityPListMap(targetName);
            Collection targetAttributes = (Collection)targetPlistMap.get("attributes");
            DbRelationship dbRel = null;
            if (dbSrc != null && dbTarget != null && (dbRel = (DbRelationship)dbSrc.getRelationship(relName)) == null) {
                dbRel = new DbRelationship();
                dbRel.setSourceEntity(dbSrc);
                dbRel.setTargetEntityName(dbTarget);
                dbRel.setToMany(toMany);
                dbRel.setName(relName);
                dbRel.setToDependentPK(toDependentPK);
                dbSrc.addRelationship(dbRel);
                List joins = (List)relMap.get("joins");
                for (Map joinMap : joins) {
                    DbJoin join = new DbJoin(dbRel);
                    String sourceAttributeName = (String)joinMap.get("sourceAttribute");
                    join.setSourceName(this.columnName(attributes, sourceAttributeName));
                    String targetAttributeName = (String)joinMap.get("destinationAttribute");
                    join.setTargetName(this.columnName(targetAttributes, targetAttributeName));
                    dbRel.addJoin(join);
                }
            }
            if (!classProps.contains(relName)) continue;
            ObjRelationship rel = new ObjRelationship();
            rel.setName(relName);
            rel.setSourceEntity(objEntity);
            rel.setTargetEntityName(target);
            objEntity.addRelationship(rel);
            if (dbRel == null) continue;
            rel.addDbRelationship(dbRel);
        }
    }

    protected void makeReverseDbRelationships(DbEntity dbEntity) {
        if (dbEntity == null) {
            throw new NullPointerException("Attempt to create reverse relationships for the null DbEntity.");
        }
        for (DbRelationship relationship : new ArrayList(dbEntity.getRelationships())) {
            if (relationship.getReverseRelationship() != null) continue;
            DbRelationship reverse = relationship.createReverseRelationship();
            reverse.setName(NameBuilder.builder(reverse, (ConfigurationNode)reverse.getSourceEntity()).baseName(relationship.getName() + "Reverse").name());
            relationship.getTargetEntity().addRelationship(reverse);
        }
    }

    protected void makeFlatRelationships(EOModelHelper helper, ObjEntity e) {
        Map info = helper.entityPListMap(e.getName());
        List rinfo = (List)info.get("relationships");
        if (rinfo == null) {
            return;
        }
        for (Map relMap : rinfo) {
            String targetPath = (String)relMap.get("definition");
            if (targetPath == null) continue;
            ObjRelationship flatRel = new ObjRelationship();
            flatRel.setName((String)relMap.get("name"));
            flatRel.setSourceEntity(e);
            try {
                flatRel.setDbRelationshipPath(targetPath);
            }
            catch (ExpressionException ex) {
                logger.warn("Invalid relationship: " + targetPath);
                continue;
            }
            Map entityInfo = info;
            StringTokenizer toks = new StringTokenizer(targetPath, ".");
            block3: while (toks.hasMoreTokens() && entityInfo != null) {
                String pathComponent = toks.nextToken();
                Collection relationshipInfo = (Collection)entityInfo.get("relationships");
                entityInfo = null;
                if (relationshipInfo == null) break;
                for (Map pathRelationship : relationshipInfo) {
                    if (!pathComponent.equals(pathRelationship.get("name"))) continue;
                    String targetName = (String)pathRelationship.get("destination");
                    entityInfo = helper.entityPListMap(targetName);
                    continue block3;
                }
            }
            if (entityInfo != null) {
                flatRel.setTargetEntityName((String)entityInfo.get("name"));
            }
            e.addRelationship(flatRel);
        }
    }

    String columnName(Collection entityAttributes, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        for (Map map : entityAttributes) {
            if (!attributeName.equals(map.get("name"))) continue;
            return (String)map.get("columnName");
        }
        return null;
    }

    static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    final class InheritanceComparator
    implements Comparator {
        DataMap dataMap;

        InheritanceComparator(DataMap dataMap) {
            this.dataMap = dataMap;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 != null ? -1 : 0;
            }
            if (o2 == null) {
                return 1;
            }
            String name1 = o1.toString();
            String name2 = o2.toString();
            ObjEntity e1 = this.dataMap.getObjEntity(name1);
            ObjEntity e2 = this.dataMap.getObjEntity(name2);
            return this.compareEntities(e1, e2);
        }

        int compareEntities(ObjEntity e1, ObjEntity e2) {
            if (e1 == null) {
                return e2 != null ? -1 : 0;
            }
            if (e2 == null) {
                return 1;
            }
            if (e1.isSubentityOf(e2)) {
                return 1;
            }
            if (e2.isSubentityOf(e1)) {
                return -1;
            }
            return e1.getName().compareTo(e2.getName());
        }
    }
}

