/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.merge.context.EntityMergeSupport;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;

public class EntitySyncController
extends CayenneController {
    private final DbEntity dbEntity;
    private ObjEntity objEntity;
    private EntitySyncDialog view;

    public EntitySyncController(CayenneController parent, DbEntity dbEntity) {
        super(parent);
        this.dbEntity = dbEntity;
    }

    public EntitySyncController(CayenneController parent, ObjEntity objEntity) {
        this(parent, objEntity.getDbEntity());
        this.objEntity = objEntity;
    }

    public EntityMergeSupport createMerger() {
        ObjectNameGenerator namingStrategy;
        Collection<ObjEntity> entities = this.getObjEntities();
        if (entities.isEmpty()) {
            return null;
        }
        try {
            namingStrategy = NameGeneratorPreferences.getInstance().createNamingStrategy(this.application);
        }
        catch (Throwable e) {
            namingStrategy = NameGeneratorPreferences.defaultNameGenerator();
        }
        EntityMergeSupport merger = new EntityMergeSupport(namingStrategy, NamePatternMatcher.EXCLUDE_ALL, true, false);
        for (ObjEntity entity : entities) {
            if (merger.getMeaningfulFKs(entity).isEmpty()) continue;
            return this.confirmMeaningfulFKs(namingStrategy);
        }
        return merger;
    }

    protected EntityMergeSupport confirmMeaningfulFKs(ObjectNameGenerator namingStrategy) {
        boolean[] cancel = new boolean[]{false};
        boolean[] removeFKs = new boolean[]{true};
        this.view = new EntitySyncDialog();
        this.view.getUpdateButton().addActionListener(e -> {
            removeFKs[0] = this.view.getRemoveFKs().isSelected();
            this.view.dispose();
        });
        this.view.getCancelButton().addActionListener(e -> {
            cancel[0] = true;
            this.view.dispose();
        });
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setVisible(true);
        return cancel[0] ? null : new EntityMergeSupport(namingStrategy, NamePatternMatcher.EXCLUDE_ALL, removeFKs[0], false);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected Collection<ObjEntity> getObjEntities() {
        return this.objEntity == null ? this.dbEntity.getDataMap().getMappedEntities(this.dbEntity) : Collections.singleton(this.objEntity);
    }
}

