/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import org.apache.cayenne.gen.CgenTemplate;

public enum TemplateType {
    ENTITY_SINGLE_CLASS(false, "Single Entity Class", "templates/v4_1/singleclass.vm"),
    ENTITY_SUPERCLASS(true, "Entity Superclass", "templates/v4_1/superclass.vm"),
    ENTITY_SUBCLASS(false, "Entity Subclass", "templates/v4_1/subclass.vm"),
    EMBEDDABLE_SINGLE_CLASS(false, "Single Embeddable Class", "templates/v4_1/embeddable-singleclass.vm"),
    EMBEDDABLE_SUPERCLASS(true, "Embeddable Superclass", "templates/v4_1/embeddable-superclass.vm"),
    EMBEDDABLE_SUBCLASS(false, "Embeddable Subclass", "templates/v4_1/embeddable-subclass.vm"),
    DATAMAP_SINGLE_CLASS(false, "Single DataMap Class", "templates/v4_1/datamap-singleclass.vm"),
    DATAMAP_SUPERCLASS(true, "DataMap Superclass", "templates/v4_1/datamap-superclass.vm"),
    DATAMAP_SUBCLASS(false, "DataMap Subclass", "templates/v4_1/datamap-subclass.vm");

    private final boolean superclass;
    private final String readableName;
    private final CgenTemplate defaultTemplate;

    private TemplateType(boolean superclass, String readableName, String defaultTemplate) {
        this.superclass = superclass;
        this.readableName = readableName;
        this.defaultTemplate = new CgenTemplate(defaultTemplate, true, this);
    }

    public boolean isSuperclass() {
        return this.superclass;
    }

    public String readableName() {
        return this.readableName;
    }

    public String pathFromSourceRoot() {
        return this.defaultTemplate.getData();
    }

    public CgenTemplate defaultTemplate() {
        return this.defaultTemplate;
    }

    public static boolean isDefault(String templateText) {
        for (TemplateType type : TemplateType.values()) {
            if (!type.pathFromSourceRoot().equals(templateText)) continue;
            return true;
        }
        return false;
    }
}

