/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

class SimpleIdIncrementalFaultList<E>
extends IncrementalFaultList<E> {
    protected DbAttribute pk;

    SimpleIdIncrementalFaultList(DataContext dataContext, Query query, int maxFetchSize, List<?> data) {
        super(dataContext, query, maxFetchSize, data);
        List<DbAttribute> pks = this.rootEntity.getDbEntity().getPrimaryKeys();
        if (pks.size() != 1) {
            throw new IllegalArgumentException("Expected a single column primary key, instead got " + pks.size() + ". ObjEntity: " + this.rootEntity.getName());
        }
        this.pk = (DbAttribute)pks.iterator().next();
    }

    @Override
    IncrementalFaultList.IncrementalListHelper createHelper(QueryMetadata metadata) {
        if (metadata.isFetchingDataRows()) {
            return new SingleIdDataRowListHelper();
        }
        return new SingleIdPersistentListHelper();
    }

    @Override
    protected Expression buildIdQualifier(Object id) {
        return ExpressionFactory.matchDbExp(this.pk.getName(), id);
    }

    class SingleIdDataRowListHelper
    extends IncrementalFaultList.DataRowListHelper {
        SingleIdDataRowListHelper() {
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Map) {
                return super.objectsAreEqual(object, objectInTheList);
            }
            if (object == null && objectInTheList == null) {
                return true;
            }
            if (object != null && objectInTheList != null) {
                Map map = (Map)object;
                return objectInTheList.equals(map.get(SimpleIdIncrementalFaultList.this.pk.getName()));
            }
            return false;
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Map) {
                return false;
            }
            Map map = (Map)object;
            return objectInTheList.equals(map.get(SimpleIdIncrementalFaultList.this.pk.getName()));
        }
    }

    class SingleIdPersistentListHelper
    extends IncrementalFaultList.PersistentListHelper {
        SingleIdPersistentListHelper() {
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return object == objectInTheList;
            }
            Persistent persistent = (Persistent)object;
            Map<String, Object> idSnapshot = persistent.getObjectId().getIdSnapshot();
            return idSnapshot.size() == 1 && objectInTheList.equals(idSnapshot.get(SimpleIdIncrementalFaultList.this.pk.getName()));
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return false;
            }
            Persistent persistent = (Persistent)object;
            Map<String, Object> idSnapshot = persistent.getObjectId().getIdSnapshot();
            return idSnapshot.size() == 1 && objectInTheList.equals(idSnapshot.get(SimpleIdIncrementalFaultList.this.pk.getName()));
        }
    }
}

