/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.Validating;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public abstract class PersistentObject
implements Persistent,
Validating {
    protected ObjectId objectId;
    protected int persistenceState = 1;
    protected transient ObjectContext objectContext;
    protected long snapshotVersion = Long.MIN_VALUE;

    @Override
    public int getPersistenceState() {
        return this.persistenceState;
    }

    @Override
    public ObjectContext getObjectContext() {
        return this.objectContext;
    }

    @Override
    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
        if (objectContext == null) {
            this.persistenceState = 1;
        }
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    protected Object getMapKey(String relationshipName, Object value) {
        EntityResolver resolver = this.objectContext.getEntityResolver();
        ClassDescriptor descriptor = resolver.getClassDescriptor(this.objectId.getEntityName());
        if (descriptor == null) {
            throw new IllegalStateException("Persistent's entity is unmapped, objectId: " + this.objectId);
        }
        PropertyDescriptor property = descriptor.getProperty(relationshipName);
        if (property instanceof ToManyMapProperty) {
            return ((ToManyMapProperty)property).getMapKey(value);
        }
        throw new IllegalArgumentException("Relationship '" + relationshipName + "' is not a to-many Map");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        return null;
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        throw new IllegalArgumentException("Unknown property: " + propName);
    }

    protected void beforePropertyRead(String propName) {
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propName, false);
        }
    }

    protected void beforePropertyWrite(String propName, Object oldValue, Object newValue) {
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propName, false);
            this.objectContext.propertyChanged(this, propName, oldValue, newValue);
        }
    }

    @Override
    public Object readProperty(String propertyName) {
        this.beforePropertyRead(propertyName);
        Object object = this.readPropertyDirectly(propertyName);
        if (object instanceof Fault) {
            object = ((Fault)object).resolveFault(this, propertyName);
            this.writePropertyDirectly(propertyName, object);
        }
        return object;
    }

    @Override
    public Object readNestedProperty(String path) {
        return this.readNestedProperty(CayennePath.of(path));
    }

    @Override
    public Object readNestedProperty(CayennePath path) {
        if (null == path || path.isEmpty()) {
            throw new IllegalArgumentException("the path must be supplied in order to lookup a nested property");
        }
        String firstSegment = path.first().value();
        Object property = this.readSimpleProperty(firstSegment);
        if (property == null) {
            return null;
        }
        if (path.length() == 1) {
            return property;
        }
        CayennePath pathRemainder = path.tail(1);
        if (property instanceof Persistent) {
            return ((Persistent)property).readNestedProperty(pathRemainder);
        }
        return Cayenne.readNestedProperty(property, pathRemainder);
    }

    Object readSimpleProperty(String property) {
        Object object = this.readProperty(property);
        if (object == null) {
            object = PropertyUtils.getProperty((Object)this, property);
        }
        return object;
    }

    @Override
    public void writeProperty(String propName, Object val) {
        Object oldValue = this.readPropertyDirectly(propName);
        this.beforePropertyWrite(propName, oldValue, val);
        this.writePropertyDirectly(propName, val);
    }

    @Override
    public void removeToManyTarget(String relName, Persistent value, boolean setReverse) {
        Object holder = this.readProperty(relName);
        this.objectContext.propertyChanged(this, relName, value, null);
        if (holder instanceof Collection) {
            ((Collection)holder).remove(value);
        } else if (holder instanceof Map) {
            ((Map)holder).remove(this.getMapKey(relName, value));
        }
        if (value != null && setReverse) {
            this.unsetReverseRelationship(relName, value);
        }
    }

    @Override
    public void addToManyTarget(String relName, Persistent value, boolean setReverse) {
        if (value == null) {
            throw new NullPointerException("Attempt to add null target Persistent.");
        }
        this.willConnect(relName, value);
        Object holder = this.readProperty(relName);
        this.objectContext.propertyChanged(this, relName, null, value);
        if (holder instanceof Collection) {
            ((Collection)holder).add(value);
        } else if (holder instanceof Map) {
            ((Map)holder).put(this.getMapKey(relName, value), value);
        }
        if (setReverse) {
            this.setReverseRelationship(relName, value);
        }
    }

    public List<? extends Persistent> setToManyTarget(String relName, Collection<? extends Persistent> values, boolean setReverse) {
        Collection old;
        if (values == null) {
            throw new IllegalArgumentException("values Collection is null. To clear all relationships use an empty Collection");
        }
        Object property = this.readProperty(relName);
        if (property == null) {
            throw new IllegalArgumentException("unknown relName " + relName);
        }
        if (property instanceof Map) {
            old = ((Map)property).values();
        } else if (property instanceof Collection) {
            old = (Collection)property;
        } else {
            throw new UnsupportedOperationException("setToManyTarget operates only with Map or Collection types");
        }
        values = new ArrayList<Persistent>(values);
        ArrayList<Persistent> removedObjects = new ArrayList<Persistent>();
        Persistent[] oldValues = old.toArray(new Persistent[0]);
        for (Persistent obj : oldValues) {
            if (values.contains(obj)) continue;
            this.removeToManyTarget(relName, obj, setReverse);
            removedObjects.add(obj);
        }
        for (Persistent persistent : old) {
            values.remove(persistent);
        }
        for (Persistent persistent : values) {
            this.addToManyTarget(relName, persistent, setReverse);
        }
        return removedObjects;
    }

    @Override
    public void setToOneTarget(String relationshipName, Persistent value, boolean setReverse) {
        this.willConnect(relationshipName, value);
        Object oldTarget = this.readProperty(relationshipName);
        if (oldTarget == value) {
            return;
        }
        this.getObjectContext().propertyChanged(this, relationshipName, oldTarget, value);
        if (setReverse) {
            if (oldTarget instanceof Persistent) {
                this.unsetReverseRelationship(relationshipName, (Persistent)oldTarget);
            }
            if (value != null) {
                this.setReverseRelationship(relationshipName, value);
            }
        }
        this.writePropertyDirectly(relationshipName, value);
    }

    protected void willConnect(String relationshipName, Persistent object) {
        if (object == null || this.getObjectContext() == object.getObjectContext()) {
            return;
        }
        if (this.getObjectContext() == null && object.getObjectContext() != null) {
            object.getObjectContext().registerNewObject(this);
        } else if (this.getObjectContext() != null && object.getObjectContext() == null) {
            this.getObjectContext().registerNewObject(object);
        } else {
            throw new CayenneRuntimeException("Cannot set object as destination of relationship %s because it is in a different ObjectContext", relationshipName);
        }
    }

    protected void setReverseRelationship(String relName, Persistent val) {
        ObjRelationship rel = this.objectContext.getEntityResolver().getObjEntity(this.objectId.getEntityName()).getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            Object oldTarget = val.readProperty(revRel.getName());
            if (oldTarget != this && oldTarget instanceof Persistent && val instanceof PersistentObject) {
                ((PersistentObject)val).unsetReverseRelationship(revRel.getName(), (Persistent)oldTarget);
            }
            if (revRel.isToMany()) {
                val.addToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), this, false);
            }
        }
    }

    protected void unsetReverseRelationship(String relName, Persistent val) {
        EntityResolver resolver = this.objectContext.getEntityResolver();
        ObjEntity entity = resolver.getObjEntity(this.objectId.getEntityName());
        if (entity == null) {
            throw new IllegalStateException("Persistent's entity is unmapped, objectId: " + this.objectId);
        }
        ObjRelationship rel = entity.getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            if (revRel.isToMany()) {
                val.removeToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), null, false);
            }
        }
    }

    @Override
    public void setPersistenceState(int persistenceState) {
        this.persistenceState = persistenceState;
    }

    @Override
    public long getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    public void setSnapshotVersion(long snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    protected void validateForSave(ValidationResult validationResult) {
        ObjEntity objEntity = this.getObjectContext().getEntityResolver().getObjEntity(this);
        if (objEntity == null) {
            throw new CayenneRuntimeException("No ObjEntity mapping found for Persistent %s", this.getClass().getName());
        }
        HashMap<String, ValidationFailure> failedDbAttributes = null;
        for (ObjAttribute next : objEntity.getAttributes()) {
            int len;
            String message;
            ValidationFailure failure;
            if (next instanceof EmbeddedAttribute) continue;
            DbAttribute dbAttribute = next.getDbAttribute();
            if (dbAttribute == null) {
                throw new CayenneRuntimeException("ObjAttribute '%s' does not have a corresponding DbAttribute", next.getName());
            }
            if (dbAttribute.isPrimaryKey()) continue;
            Object value = this.readPropertyDirectly(next.getName());
            if (dbAttribute.isMandatory() && (failure = BeanValidationFailure.validateNotNull(this, next.getName(), value)) != null) {
                if (failedDbAttributes == null) {
                    failedDbAttributes = new HashMap<String, ValidationFailure>();
                }
                failedDbAttributes.put(dbAttribute.getName(), failure);
                continue;
            }
            if (value == null || dbAttribute.getMaxLength() <= 0) continue;
            if (value.getClass().isArray()) {
                int len2 = Array.getLength(value);
                if (len2 <= dbAttribute.getMaxLength()) continue;
                message = "\"" + next.getName() + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " bytes): " + len2;
                validationResult.addFailure(new BeanValidationFailure(this, next.getName(), message));
                continue;
            }
            if (!(value instanceof CharSequence) || (len = ((CharSequence)value).length()) <= dbAttribute.getMaxLength()) continue;
            message = "\"" + next.getName() + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " chars): " + len;
            validationResult.addFailure(new BeanValidationFailure(this, next.getName(), message));
        }
        for (ObjRelationship relationship : objEntity.getRelationships()) {
            List<DbRelationship> dbRels = relationship.getDbRelationships();
            if (dbRels.isEmpty() || relationship.isSourceIndependentFromTargetChange()) continue;
            boolean validate = true;
            for (DbRelationship dbRelationship : dbRels) {
                for (DbJoin join : dbRelationship.getJoins()) {
                    DbAttribute source = join.getSource();
                    if (source.isMandatory()) {
                        if (failedDbAttributes == null || failedDbAttributes.isEmpty()) continue;
                        failedDbAttributes.remove(source.getName());
                        continue;
                    }
                    validate = false;
                }
            }
            if (!validate) continue;
            Object value = this.readPropertyDirectly(relationship.getName());
            ValidationFailure failure = BeanValidationFailure.validateNotNull(this, relationship.getName(), value);
            if (failure == null) continue;
            validationResult.addFailure(failure);
        }
        if (failedDbAttributes != null && !failedDbAttributes.isEmpty()) {
            for (ValidationFailure failure : failedDbAttributes.values()) {
                validationResult.addFailure(failure);
            }
        }
    }

    @Override
    public void validateForInsert(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    @Override
    public void validateForUpdate(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    @Override
    public void validateForDelete(ValidationResult validationResult) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readSerialized(in);
    }

    protected void writeSerialized(ObjectOutputStream out) throws IOException {
        out.writeInt(this.persistenceState);
        out.writeObject(this.objectId);
        if (this.persistenceState == 3 || this.persistenceState == 5) {
            return;
        }
        this.writeState(out);
    }

    protected void readSerialized(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.persistenceState = in.readInt();
        this.objectId = (ObjectId)in.readObject();
        if (this.persistenceState == 3 || this.persistenceState == 5) {
            this.persistenceState = 5;
            return;
        }
        this.readState(in);
    }

    protected void writeState(ObjectOutputStream out) throws IOException {
    }

    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    public StringBuffer toStringBuffer(StringBuffer buffer, boolean fullDesc) {
        String id = this.objectId != null ? this.objectId.toString() : "<no id>";
        String state = PersistenceState.persistenceStateName(this.persistenceState);
        buffer.append('{').append(id).append("; ").append(state).append("; ");
        if (fullDesc) {
            this.appendProperties(buffer);
        }
        buffer.append("}");
        return buffer;
    }

    protected void appendProperties(StringBuffer buffer) {
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer(), true).toString();
    }
}

