/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DataMapValidator
extends ConfigurationNodeValidator {
    DataMapValidator() {
    }

    void validate(DataMap map, ValidationResult validationResult) {
        this.validateName(map, validationResult);
        this.validateNodeLinks(map, validationResult);
        this.validateJavaPackage(map, validationResult);
    }

    private void validateNodeLinks(DataMap map, ValidationResult validationResult) {
        DataChannelDescriptor domain = map.getDataChannelDescriptor();
        if (domain == null) {
            return;
        }
        boolean unlinked = true;
        int nodeCount = 0;
        for (DataNodeDescriptor node : domain.getNodeDescriptors()) {
            ++nodeCount;
            if (!node.getDataMapNames().contains(map.getName())) continue;
            unlinked = false;
            break;
        }
        if (unlinked && nodeCount > 0) {
            this.addFailure(validationResult, map, "DataMap is not linked to any DataNodes", new Object[0]);
        }
    }

    private void validateName(DataMap map, ValidationResult validationResult) {
        String name = map.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, map, "Unnamed DataMap", new Object[0]);
            return;
        }
        DataChannelDescriptor domain = map.getDataChannelDescriptor();
        if (domain == null) {
            return;
        }
        for (DataMap otherMap : domain.getDataMaps()) {
            if (otherMap == map || !name.equals(otherMap.getName())) continue;
            this.addFailure(validationResult, map, "Duplicate DataMap name: %s", name);
            return;
        }
    }

    private void validateJavaPackage(DataMap map, ValidationResult validationResult) {
        String javaPackage = map.getDefaultPackage();
        if (Util.isEmptyString((CharSequence)javaPackage)) {
            this.addFailure(validationResult, map, "Java package is not set in DataMap '%s'", map.getName());
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(javaPackage);
        if (invalidChars != null) {
            this.addFailure(validationResult, map, "DataMap '%s' Java package '%s' contains invalid characters: %s", map.getName(), javaPackage, invalidChars);
        }
    }
}

