/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityFromDbAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntityCounterpartAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributePanel;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityRelationshipPanel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;
import org.slf4j.LoggerFactory;

public class DbEntityAttributeRelationshipTab
extends JPanel
implements DbEntityDisplayListener,
DbEntityListener {
    public DbEntityAttributePanel attributePanel;
    public DbEntityRelationshipPanel relationshipPanel;
    public JButton resolve = new CayenneAction.CayenneToolbarButton(null, 0);
    private JSplitPane splitPane;
    private ProjectController mediator;
    private CutAttributeRelationshipAction cut;
    private RemoveAttributeRelationshipAction remove;
    private CopyAttributeRelationshipAction copy;
    private JToolBar toolBar;

    public DbEntityAttributeRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initToolBar();
        mediator.addDbEntityDisplayListener(this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.attributePanel = new DbEntityAttributePanel(this.mediator, this);
        this.relationshipPanel = new DbEntityRelationshipPanel(this.mediator, this);
        this.splitPane = new JSplitPane(0, this.attributePanel, this.relationshipPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.5);
        try {
            ComponentGeometry geometry = new ComponentGeometry(this.getClass(), "dbEntityAttrRelTab/splitPane/divider");
            geometry.bindIntProperty(this.splitPane, "dividerLocation", -1);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot bind divider property", ex);
        }
        this.add(this.splitPane);
    }

    private void initToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton(3));
        this.toolBar.addSeparator();
        this.toolBar.add(actionManager.getAction(CreateObjEntityFromDbAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(DbEntitySyncAction.class).buildButton(2));
        this.toolBar.add(actionManager.getAction(DbEntityCounterpartAction.class).buildButton(3));
        this.toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-edit.png");
        this.resolve.setToolTipText("Edit Relationship");
        this.resolve.setIcon(ico);
        this.resolve.setDisabledIcon(FilteredIconFactory.createDisabledIcon(ico));
        this.toolBar.add(this.resolve).setEnabled(false);
        this.cut = actionManager.getAction(CutAttributeRelationshipAction.class);
        this.remove = actionManager.getAction(RemoveAttributeRelationshipAction.class);
        this.copy = actionManager.getAction(CopyAttributeRelationshipAction.class);
        this.toolBar.addSeparator();
        this.toolBar.add(this.remove.buildButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.cut.buildButton(1));
        this.toolBar.add(this.copy.buildButton(2));
        this.toolBar.add(actionManager.getAction(PasteAction.class).buildButton(3));
        this.add((Component)this.toolBar, "North");
    }

    public void updateActions(Object[] params) {
        ModelerUtil.updateActions(params.length, RemoveAttributeRelationshipAction.class, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
        if (params instanceof DbRelationship[]) {
            this.resolve.setEnabled(params.length > 0);
        }
    }

    public JButton getResolve() {
        return this.resolve;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public DbEntityAttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public DbEntityRelationshipPanel getRelationshipPanel() {
        return this.relationshipPanel;
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        this.relationshipPanel.dbEntityChanged(e);
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
        this.relationshipPanel.dbEntityAdded(e);
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
        this.relationshipPanel.dbEntityRemoved(e);
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity.getDataMap().getMappedEntities(entity).isEmpty()) {
            this.toolBar.getComponentAtIndex(4).setEnabled(false);
            this.toolBar.getComponentAtIndex(5).setEnabled(false);
        } else {
            this.toolBar.getComponentAtIndex(4).setEnabled(true);
            this.toolBar.getComponentAtIndex(5).setEnabled(true);
        }
    }
}

