/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
class SubstringEval
extends AbstractScalarEval {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable argString = new VoidPointable();
    private final IPointable argStart = new VoidPointable();
    private final IPointable argLen = new VoidPointable();
    private final IEvaluatorContext ctx;
    private final IScalarEvaluator evalString;
    private final IScalarEvaluator evalStart;
    private final IScalarEvaluator evalLen;
    private final int baseOffset;
    private final GrowableArray array = new GrowableArray();
    private final UTF8StringBuilder builder = new UTF8StringBuilder();
    private final UTF8StringPointable string = new UTF8StringPointable();
    private final AMutableInt32 mutableInt32 = new AMutableInt32(0);

    SubstringEval(IEvaluatorContext ctx, IScalarEvaluatorFactory[] args, FunctionIdentifier functionIdentifier, SourceLocation sourceLoc, int baseOffset) throws HyracksDataException {
        super(sourceLoc, functionIdentifier);
        this.ctx = ctx;
        this.evalString = args[0].createScalarEvaluator(ctx);
        this.evalStart = args[1].createScalarEvaluator(ctx);
        this.evalLen = args[2].createScalarEvaluator(ctx);
        this.baseOffset = baseOffset;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.evalString.evaluate(tuple, this.argString);
        this.evalStart.evaluate(tuple, this.argStart);
        this.evalLen.evaluate(tuple, this.argLen);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argString, this.argStart, this.argLen)) {
            return;
        }
        byte[] bytes = this.argStart.getByteArray();
        if (!ArgumentUtils.setInteger(this.ctx, this.srcLoc, this.funID, 1, bytes, offset = this.argStart.getStartOffset(), this.mutableInt32)) {
            PointableHelper.setNull(result);
            return;
        }
        int start = this.mutableInt32.getIntegerValue();
        bytes = this.argLen.getByteArray();
        if (!ArgumentUtils.setInteger(this.ctx, this.srcLoc, this.funID, 2, bytes, offset = this.argLen.getStartOffset(), this.mutableInt32)) {
            PointableHelper.setNull(result);
            return;
        }
        int len = this.mutableInt32.getIntegerValue();
        bytes = this.argString.getByteArray();
        offset = this.argString.getStartOffset();
        int length = this.argString.getLength();
        if (bytes[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(result);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[offset], (int)0, (ATypeTag)ATypeTag.STRING);
            return;
        }
        this.string.set(bytes, offset + 1, length - 1);
        this.array.reset();
        try {
            int actualStart = start >= 0 ? Math.max(start - this.baseOffset, 0) : this.string.getStringLength() + start;
            boolean success = UTF8StringPointable.substr((UTF8StringPointable)this.string, (int)actualStart, (int)len, (UTF8StringBuilder)this.builder, (GrowableArray)this.array);
            if (success) {
                this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                this.out.write(this.array.getByteArray(), 0, this.array.getLength());
                result.set((IValueReference)this.resultStorage);
            } else {
                PointableHelper.setNull(result);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

