/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<I, R> {
    public R process(I var1) throws Exception;

    public static <I, R> Function<I, R> asUnchecked(ThrowingFunction<I, R> consumer) {
        return input -> {
            try {
                return consumer.process(input);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
        };
    }
}

