/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;
import org.apache.hyracks.dataflow.std.sort.AbstractSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.Algorithm;
import org.apache.hyracks.dataflow.std.sort.FrameSorterMergeSort;
import org.apache.hyracks.dataflow.std.sort.FrameSorterQuickSort;
import org.apache.hyracks.dataflow.std.sort.IFrameSorter;
import org.apache.hyracks.dataflow.std.sort.ISorter;

public abstract class AbstractExternalSortRunGenerator
extends AbstractSortRunGenerator {
    protected final IHyracksTaskContext ctx;
    protected final IFrameSorter frameSorter;
    protected final int maxSortFrames;

    public AbstractExternalSortRunGenerator(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, Algorithm alg, int framesLimit) throws HyracksDataException {
        this(ctx, sortFields, keyNormalizerFactories, comparatorFactories, recordDesc, alg, EnumFreeSlotPolicy.LAST_FIT, framesLimit);
    }

    public AbstractExternalSortRunGenerator(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, Algorithm alg, EnumFreeSlotPolicy policy, int framesLimit) throws HyracksDataException {
        this(ctx, sortFields, keyNormalizerFactories, comparatorFactories, recordDesc, alg, policy, framesLimit, Integer.MAX_VALUE);
    }

    public AbstractExternalSortRunGenerator(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, Algorithm alg, EnumFreeSlotPolicy policy, int framesLimit, int outputLimit) throws HyracksDataException {
        this.ctx = ctx;
        this.maxSortFrames = framesLimit - 1;
        IFrameFreeSlotPolicy freeSlotPolicy = FrameFreeSlotPolicyFactory.createFreeSlotPolicy(policy, this.maxSortFrames);
        VariableFrameMemoryManager bufferManager = new VariableFrameMemoryManager(new VariableFramePool((IHyracksFrameMgrContext)ctx, this.maxSortFrames * ctx.getInitialFrameSize()), freeSlotPolicy);
        this.frameSorter = alg == Algorithm.MERGE_SORT ? new FrameSorterMergeSort(ctx, bufferManager, this.maxSortFrames, sortFields, keyNormalizerFactories, comparatorFactories, recordDesc, outputLimit) : new FrameSorterQuickSort(ctx, bufferManager, this.maxSortFrames, sortFields, keyNormalizerFactories, comparatorFactories, recordDesc, outputLimit);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (!this.frameSorter.insertFrame(buffer)) {
            this.flushFramesToRun();
            if (!this.frameSorter.insertFrame(buffer)) {
                throw new HyracksDataException("The given frame is too big to insert into the sorting memory.");
            }
        }
    }

    @Override
    public ISorter getSorter() {
        return this.frameSorter;
    }
}

