/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.CardinalityInferenceVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.IPropertiesComputer;
import org.apache.hyracks.algebricks.core.algebra.properties.UnpartitionedPropertyComputer;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveRedundantListifyRule
implements IAlgebraicRewriteRule {
    private final boolean allowReverseCaseAtSubplanRoot;

    public RemoveRedundantListifyRule(boolean allowReverseCaseAtSubplanRoot) {
        this.allowReverseCaseAtSubplanRoot = allowReverseCaseAtSubplanRoot;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        HashSet<LogicalVariable> varSet = new HashSet<LogicalVariable>();
        return this.applyRuleDown(opRef, false, varSet, context);
    }

    private boolean applyRuleDown(Mutable<ILogicalOperator> opRef, boolean isSubplanRoot, Set<LogicalVariable> varSet, IOptimizationContext context) throws AlgebricksException {
        boolean skipReverseCase;
        boolean changed = this.applies(opRef, varSet, context);
        boolean bl = skipReverseCase = isSubplanRoot && !this.allowReverseCaseAtSubplanRoot;
        if (!skipReverseCase) {
            changed |= this.appliesForReverseCase(opRef, varSet, context);
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, varSet);
        if (op.hasNestedPlans()) {
            boolean isSubplanOp = op.getOperatorTag() == LogicalOperatorTag.SUBPLAN;
            ListSet localLiveVars = new ListSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)op, (Collection)localLiveVars);
            varSet.retainAll((Collection<?>)localLiveVars);
            AbstractOperatorWithNestedPlans aonp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : aonp.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    if (this.applyRuleDown((Mutable<ILogicalOperator>)r, isSubplanOp, varSet, context)) {
                        changed = true;
                    }
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)r.getValue());
                }
            }
        }
        for (Mutable i : op.getInputs()) {
            if (this.applyRuleDown((Mutable<ILogicalOperator>)i, false, varSet, context)) {
                changed = true;
            }
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)i.getValue());
        }
        return changed;
    }

    private boolean applies(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> varUsedAbove, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest1 = (UnnestOperator)op1;
        ILogicalExpression expr = (ILogicalExpression)unnest1.getExpressionRef().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        if (((AbstractFunctionCallExpression)expr).getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return false;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)expr;
        ILogicalExpression functionCallArgExpr = (ILogicalExpression)((Mutable)functionCall.getArguments().get(0)).getValue();
        if (functionCallArgExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable unnestedVar = ((VariableReferenceExpression)functionCallArgExpr).getVariableReference();
        if (varUsedAbove.contains(unnestedVar)) {
            return false;
        }
        Mutable aggregateParentRef = opRef;
        AbstractLogicalOperator r = op1;
        boolean metAggregate = false;
        while (r.getInputs().size() == 1) {
            aggregateParentRef = (Mutable)r.getInputs().get(0);
            if ((r = (AbstractLogicalOperator)aggregateParentRef.getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assign = (AssignOperator)r;
                List variables = assign.getVariables();
                if (!variables.contains(unnestedVar)) continue;
                return false;
            }
            if (r.getOperatorTag() != LogicalOperatorTag.AGGREGATE) break;
            metAggregate = true;
            break;
        }
        if (!metAggregate) {
            return false;
        }
        AggregateOperator agg = (AggregateOperator)r;
        if (agg.getVariables().size() > 1) {
            return false;
        }
        LogicalVariable aggVar = (LogicalVariable)agg.getVariables().get(0);
        ILogicalExpression aggFun = (ILogicalExpression)((Mutable)agg.getExpressions().get(0)).getValue();
        if (!aggVar.equals((Object)unnestedVar) || aggFun.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)aggFun;
        if (!BuiltinFunctions.LISTIFY.equals((Object)f.getFunctionIdentifier())) {
            return false;
        }
        if (f.getArguments().size() != 1) {
            return false;
        }
        ILogicalExpression arg0 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (arg0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable paramVar = ((VariableReferenceExpression)arg0).getVariableReference();
        ArrayList<LogicalVariable> assgnVars = new ArrayList<LogicalVariable>(1);
        assgnVars.add(unnest1.getVariable());
        ArrayList<MutableObject> assgnExprs = new ArrayList<MutableObject>(1);
        VariableReferenceExpression paramVarRef = new VariableReferenceExpression(paramVar);
        paramVarRef.setSourceLocation(arg0.getSourceLocation());
        assgnExprs.add(new MutableObject((Object)paramVarRef));
        AssignOperator assign = new AssignOperator(assgnVars, assgnExprs);
        assign.setSourceLocation(agg.getSourceLocation());
        assign.getInputs().add((Mutable)agg.getInputs().get(0));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
        LogicalVariable posVar = unnest1.getPositionalVariable();
        if (posVar == null) {
            aggregateParentRef.setValue((Object)assign);
        } else {
            ArrayList<LogicalVariable> raggVars = new ArrayList<LogicalVariable>(1);
            raggVars.add(posVar);
            ArrayList<MutableObject> rAggExprs = new ArrayList<MutableObject>(1);
            StatefulFunctionCallExpression tidFun = new StatefulFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.TID), (IPropertiesComputer)UnpartitionedPropertyComputer.INSTANCE);
            tidFun.setSourceLocation(agg.getSourceLocation());
            rAggExprs.add(new MutableObject((Object)tidFun));
            RunningAggregateOperator rAgg = new RunningAggregateOperator(raggVars, rAggExprs);
            rAgg.setSourceLocation(agg.getSourceLocation());
            rAgg.getInputs().add(new MutableObject((Object)assign));
            aggregateParentRef.setValue((Object)rAgg);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)rAgg);
        }
        opRef.setValue((Object)((ILogicalOperator)((Mutable)unnest1.getInputs().get(0)).getValue()));
        return true;
    }

    private boolean appliesForReverseCase(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> varUsedAbove, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator agg = (AggregateOperator)op1;
        if (agg.getVariables().size() != 1) {
            return false;
        }
        LogicalVariable aggVar = (LogicalVariable)agg.getVariables().get(0);
        ILogicalExpression aggFun = (ILogicalExpression)((Mutable)agg.getExpressions().get(0)).getValue();
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)aggFun;
        if (!BuiltinFunctions.LISTIFY.equals((Object)f.getFunctionIdentifier())) {
            return false;
        }
        if (f.getArguments().size() != 1) {
            return false;
        }
        ILogicalExpression arg0 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (arg0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable aggInputVar = ((VariableReferenceExpression)arg0).getVariableReference();
        if (varUsedAbove.contains(aggInputVar)) {
            return false;
        }
        if (agg.getInputs().size() == 0) {
            return false;
        }
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)agg.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op2;
        if (unnest.getPositionalVariable() != null) {
            return false;
        }
        if (!unnest.getVariable().equals((Object)aggInputVar)) {
            return false;
        }
        ILogicalExpression unnestArg = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (unnestArg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression scanFunc = (AbstractFunctionCallExpression)unnestArg;
        if (scanFunc.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return false;
        }
        if (scanFunc.getArguments().size() != 1) {
            return false;
        }
        ILogicalOperator unnestInputOp = (ILogicalOperator)((Mutable)unnest.getInputs().get(0)).getValue();
        if (!CardinalityInferenceVisitor.isCardinalityExactOne((ILogicalOperator)unnestInputOp)) {
            return false;
        }
        ArrayList<LogicalVariable> assgnVars = new ArrayList<LogicalVariable>(1);
        assgnVars.add(aggVar);
        AssignOperator assign = new AssignOperator(assgnVars, scanFunc.getArguments());
        assign.setSourceLocation(agg.getSourceLocation());
        assign.getInputs().add(new MutableObject((Object)unnestInputOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
        opRef.setValue((Object)assign);
        return true;
    }
}

