/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromAddressReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPBridgeFromAddressPolicyManager
extends AMQPBridgeFromPolicyManager
implements ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeAddressPolicy policy;
    private final Map<String, AMQPBridgeAddressReceiverManager> bridgeReceivers = new HashMap<String, AMQPBridgeAddressReceiverManager>();
    private final Map<DivertBinding, Set<QueueBinding>> divertsTracking = new HashMap<DivertBinding, Set<QueueBinding>>();

    public AMQPBridgeFromAddressPolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, AMQPBridgeAddressPolicy addressPolicy) {
        super(bridge, metrics, addressPolicy.getPolicyName(), AMQPBridgeType.BRIDGE_FROM_ADDRESS);
        Objects.requireNonNull(addressPolicy, "The Address match policy cannot be null");
        this.policy = addressPolicy;
    }

    @Override
    public AMQPBridgeAddressPolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void scanManagedResources() {
        if (this.configuration.isReceiverDemandTrackingDisabled()) {
            this.scanAllAddresses();
        } else {
            this.scanAllBindings();
        }
    }

    @Override
    protected void safeCleanupManagerResources(boolean force) {
        try {
            this.bridgeReceivers.values().forEach(manager -> {
                if (manager != null) {
                    if (this.isConnected() && !force) {
                        manager.shutdown();
                    } else {
                        manager.shutdownNow();
                    }
                }
            });
        }
        finally {
            this.bridgeReceivers.clear();
            this.divertsTracking.clear();
        }
    }

    public synchronized void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        AMQPBridgeAddressReceiverManager manager;
        if (this.isActive() && (manager = this.bridgeReceivers.remove(address.toString())) != null) {
            manager.shutdownNow();
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (this.isActive() && !this.configuration.isReceiverDemandTrackingDisabled()) {
            DivertBinding divert;
            if (binding instanceof QueueBinding) {
                AMQPBridgeAddressReceiverManager manager = this.bridgeReceivers.get(binding.getAddress().toString());
                if (manager != null) {
                    this.tryRemoveDemandOnAddress(manager, binding);
                } else if (this.policy.isIncludeDivertBindings()) {
                    this.divertsTracking.entrySet().forEach(divertEntry -> {
                        String sourceAddress = ((DivertBinding)divertEntry.getKey()).getAddress().toString();
                        SimpleString forwardAddress = ((DivertBinding)divertEntry.getKey()).getDivert().getForwardAddress();
                        if (AMQPBridgeFromAddressPolicyManager.isAddressInDivertForwards(binding.getAddress(), forwardAddress)) {
                            ((Set)divertEntry.getValue()).remove(binding);
                            if (((Set)divertEntry.getValue()).isEmpty()) {
                                this.tryRemoveDemandOnAddress(this.bridgeReceivers.get(sourceAddress), (Binding)divertEntry.getKey());
                            }
                        }
                    });
                }
            } else if (this.policy.isIncludeDivertBindings() && binding instanceof DivertBinding && this.divertsTracking.remove(divert = (DivertBinding)binding) != null) {
                try {
                    this.tryRemoveDemandOnAddress(this.bridgeReceivers.get(divert.getAddress().toString()), (Binding)divert);
                }
                catch (Exception e) {
                    logger.warn("Error looking up binding for divert forward address {}", (Object)divert.getDivert().getForwardAddress(), (Object)e);
                }
            }
        }
    }

    private void tryRemoveDemandOnAddress(AMQPBridgeAddressReceiverManager manager, Binding binding) {
        if (manager != null) {
            logger.trace("Reducing demand on bridged address {}", (Object)manager.getAddress());
            manager.removeDemand(binding);
        }
    }

    private void scanAllAddresses() {
        this.server.getPostOffice().getAddresses().stream().map(address -> this.server.getAddressInfo(address)).filter(addressInfo -> this.testIfAddressMatchesPolicy((AddressInfo)addressInfo)).forEach(addressInfo -> this.createOrUpdateAddressReceiverForUnboundDemand((AddressInfo)addressInfo));
    }

    private void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(binding -> binding instanceof QueueBinding || this.policy.isIncludeDivertBindings() && binding instanceof DivertBinding).forEach(binding -> this.afterAddBinding((Binding)binding));
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.isActive() && this.policy.test(addressInfo)) {
            if (this.configuration.isReceiverDemandTrackingDisabled()) {
                this.createOrUpdateAddressReceiverForUnboundDemand(addressInfo);
            } else if (this.policy.isIncludeDivertBindings()) {
                try {
                    this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::checkBindingForMatch);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.bridgeBindingsLookupError(addressInfo.getName(), (Throwable)e);
                }
            }
        }
    }

    public synchronized void afterAddBinding(Binding binding) {
        if (this.isActive() && !this.configuration.isReceiverDemandTrackingDisabled()) {
            this.checkBindingForMatch(binding);
        }
    }

    private void checkBindingForMatch(Binding binding) {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            if (this.testIfAddressMatchesPolicy(addressInfo)) {
                this.createOrUpdateAddressReceiverForBinding(addressInfo, (Binding)queueBinding);
            } else {
                this.reactIfQueueBindingMatchesAnyDivertTarget(queueBinding);
            }
        } else if (binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            this.reactIfAnyQueueBindingMatchesDivertTarget(divertBinding);
        }
    }

    private void reactIfAnyQueueBindingMatchesDivertTarget(DivertBinding divertBinding) {
        if (!this.policy.isIncludeDivertBindings()) {
            return;
        }
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (!this.testIfAddressMatchesPolicy(addressInfo)) {
            return;
        }
        if (this.divertsTracking.get(divertBinding) == null) {
            HashSet matchingQueues = new HashSet();
            this.divertsTracking.put(divertBinding, matchingQueues);
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            SimpleString[] forwardAddresses = forwardAddress.split(',');
            try {
                for (SimpleString forward : forwardAddresses) {
                    this.server.getPostOffice().getBindingsForAddress(forward).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> {
                        matchingQueues.add(queueBinding);
                        this.createOrUpdateAddressReceiverForBinding(addressInfo, (Binding)divertBinding);
                    });
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.bridgeBindingsLookupError(forwardAddress, (Throwable)e);
            }
        }
    }

    private void reactIfQueueBindingMatchesAnyDivertTarget(QueueBinding queueBinding) {
        if (!this.policy.isIncludeDivertBindings()) {
            return;
        }
        SimpleString queueAddress = queueBinding.getAddress();
        this.divertsTracking.entrySet().forEach(e -> {
            SimpleString forwardAddress = ((DivertBinding)e.getKey()).getDivert().getForwardAddress();
            DivertBinding divertBinding = (DivertBinding)e.getKey();
            if (!((Set)e.getValue()).contains(queueBinding) && AMQPBridgeFromAddressPolicyManager.isAddressInDivertForwards(queueAddress, forwardAddress)) {
                ((Set)e.getValue()).add(queueBinding);
                AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
                this.createOrUpdateAddressReceiverForBinding(addressInfo, (Binding)divertBinding);
            }
        });
    }

    private static boolean isAddressInDivertForwards(SimpleString targetAddress, SimpleString forwardAddress) {
        SimpleString[] forwardAddresses;
        for (SimpleString forward : forwardAddresses = forwardAddress.split(',')) {
            if (!targetAddress.equals((Object)forward)) continue;
            return true;
        }
        return false;
    }

    private void createOrUpdateAddressReceiverForUnboundDemand(AddressInfo addressInfo) {
        logger.trace("AMQP Bridge Address Policy matched on address: {} when demand tracking disabled", (Object)addressInfo);
        this.createOrUpdateAddressReceiver(addressInfo, null, true);
    }

    private void createOrUpdateAddressReceiverForBinding(AddressInfo addressInfo, Binding binding) {
        logger.trace("AMQP Bridge Address Policy matched on for demand on address: {} : binding: {}", (Object)addressInfo, (Object)binding);
        this.createOrUpdateAddressReceiver(addressInfo, binding, false);
    }

    private void createOrUpdateAddressReceiver(AddressInfo addressInfo, Binding binding, boolean forceDemand) {
        AMQPBridgeAddressReceiverManager manager;
        String addressName = addressInfo.getName().toString();
        if (this.bridgeReceivers.containsKey(addressName)) {
            manager = this.bridgeReceivers.get(addressName);
        } else {
            manager = new AMQPBridgeAddressReceiverManager(this, this.configuration, addressInfo);
            this.bridgeReceivers.put(addressName, manager);
        }
        if (forceDemand) {
            manager.forceDemand();
        } else {
            manager.addDemand(binding);
        }
    }

    private AMQPBridgeReceiverInfo createReceiverInfo(AddressInfo address) {
        String addressName = address.getName().toString();
        StringBuilder remoteAddressBuilder = new StringBuilder();
        if (this.policy.getRemoteAddressPrefix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressPrefix());
        }
        if (this.policy.getRemoteAddress() != null && !this.policy.getRemoteAddress().isBlank()) {
            remoteAddressBuilder.append(this.policy.getRemoteAddress());
        } else {
            remoteAddressBuilder.append(addressName);
        }
        if (this.policy.getRemoteAddressSuffix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressSuffix());
        }
        return new AMQPBridgeReceiverInfo(AMQPBridgeReceiverInfo.ReceiverRole.ADDRESS_RECEIVER, addressName, null, address.getRoutingType(), remoteAddressBuilder.toString(), this.policy.getFilter(), this.configuration.isReceiverPriorityDisabled() ? null : this.policy.getPriority());
    }

    private AMQPBridgeReceiver createBridgeReceiver(AMQPBridgeReceiverInfo receiverInfo) {
        Objects.requireNonNull(receiverInfo, "AMQP Bridge Address receiver information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Bridge {} creating address receiver: {} for policy: {}", new Object[]{this.bridge.getName(), receiverInfo, this.policy.getPolicyName()});
        }
        return new AMQPBridgeFromAddressReceiver((AMQPBridgeFromPolicyManager)this, this.configuration, this.session, receiverInfo, this.policy, this.metrics.newReceiverMetrics());
    }

    private boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        if (!this.policy.test(addressInfo)) {
            return false;
        }
        if (this.configuration.getReceiverCredits() <= 0) {
            logger.debug("AMQP Bridge address policy rejecting match on {} because credit is set to zero:", (Object)addressInfo.getName());
            return false;
        }
        return true;
    }

    private static class AMQPBridgeAddressReceiverManager
    extends AMQPBridgeReceiverManager<Binding> {
        private final AMQPBridgeFromAddressPolicyManager manager;
        private final AddressInfo addressInfo;

        AMQPBridgeAddressReceiverManager(AMQPBridgeFromAddressPolicyManager manager, AMQPBridgeReceiverConfiguration configuration, AddressInfo addressInfo) {
            super(manager, configuration);
            this.manager = manager;
            this.addressInfo = addressInfo;
        }

        public AddressInfo getAddressInfo() {
            return this.addressInfo;
        }

        public String getAddress() {
            return this.getAddressInfo().getName().toString();
        }

        @Override
        protected AMQPBridgeReceiver createBridgeReceiver() {
            return this.manager.createBridgeReceiver(this.manager.createReceiverInfo(this.addressInfo));
        }

        @Override
        protected void whenDemandTrackingEntryAdded(Binding entry) {
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(Binding entry) {
        }
    }
}

