/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;

public class FloatConverter
extends AbstractDecimalConverter<Float> {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal MIN_VALUE = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    public static final IConverter<Float> INSTANCE = new FloatConverter();

    @Override
    public Float convertToObject(String value, Locale locale) {
        BigDecimal number = this.parse(value, MIN_VALUE, MAX_VALUE, locale);
        if (number == null) {
            return null;
        }
        return Float.valueOf(number.floatValue());
    }

    @Override
    protected Class<Float> getTargetType() {
        return Float.class;
    }
}

