/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class RutaStructureAction
extends RutaAction {
    private Expression structure;
    private Map<Expression, Expression> assignments;

    public RutaStructureAction(int start, int end, List<ASTNode> exprs, int kind, String name, int nameStart, int nameEnd, Map<Expression, Expression> assignments, Expression structure) {
        super(start, end, exprs, kind, name, nameStart, nameEnd);
        this.assignments = assignments;
        this.structure = structure;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            this.structure.traverse(visitor);
            for (ASTNode e : this.exprs) {
                e.traverse(visitor);
            }
            for (Map.Entry<Expression, Expression> pairs : this.assignments.entrySet()) {
                if (pairs.getKey() == null || pairs.getValue() == null) break;
                pairs.getKey().traverse(visitor);
                pairs.getValue().traverse(visitor);
            }
        }
    }

    @Override
    public List<ASTNode> getChilds() {
        ArrayList<ASTNode> l = new ArrayList<ASTNode>();
        l.add((ASTNode)this.structure);
        l.addAll(this.assignments.keySet());
        l.addAll(this.assignments.values());
        l.addAll(super.getChilds());
        return l;
    }

    public Map<Expression, Expression> getAssignments() {
        return this.assignments;
    }

    public Expression getStructure() {
        return this.structure;
    }

    public List<ASTNode> getExpressions() {
        return this.exprs;
    }
}

